/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk.utils;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;

public class FileUitls {
    public static boolean isSdCardAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static File getSDRootFile() {
        if (FileUitls.isSdCardAvailable()) {
            return Environment.getExternalStorageDirectory();
        }
        return null;
    }

    public static File getFaceDirectory() {
        File sdRootFile = FileUitls.getSDRootFile();
        File file = null;
        if (sdRootFile != null && sdRootFile.exists() && !(file = new File(sdRootFile, "faces")).exists()) {
            boolean bl = file.mkdirs();
        }
        return file;
    }

    public static File getBatchFaceDirectory(String batchDir) {
        File sdRootFile = FileUitls.getSDRootFile();
        File file = null;
        if (sdRootFile != null && sdRootFile.exists() && !(file = new File(sdRootFile, batchDir)).exists()) {
            boolean bl = file.mkdirs();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveFile(File file, Bitmap bitmap) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void deleteLicense(Context context, String licenseName) {
        File var4;
        String filePath = context.getFilesDir().getParent() + "/" + licenseName;
        File file = new File(filePath);
        if (file.exists()) {
            file.delete();
        }
        if ((var4 = context.getDir(licenseName, 0)) != null && var4.exists()) {
            var4.delete();
        }
    }

    public static boolean fileIsExists(String strFile) {
        try {
            File f = new File(strFile);
            if (!f.exists()) {
                Log.i((String)"wtf", (String)"file_state->file not exits");
                return false;
            }
        }
        catch (Exception e) {
            Log.i((String)"wtf", (String)("file_state->" + e.getMessage()));
            return false;
        }
        return true;
    }

    public static String readFile(String strFilePath) {
        String path = strFilePath;
        String content = "";
        File file = new File(path);
        if (file.isDirectory()) {
            Log.d((String)"TestFile", (String)"The File doesn't not exist.");
        } else {
            try {
                FileInputStream instream = new FileInputStream(file);
                if (instream != null) {
                    String line;
                    InputStreamReader inputreader = new InputStreamReader(instream);
                    BufferedReader buffreader = new BufferedReader(inputreader);
                    while ((line = buffreader.readLine()) != null) {
                        content = line;
                    }
                    ((InputStream)instream).close();
                }
            }
            catch (FileNotFoundException e) {
                Log.d((String)"TestFile", (String)"The File doesn't not exist.");
            }
            catch (IOException e) {
                Log.d((String)"TestFile", (String)e.getMessage());
            }
        }
        return content;
    }

    public static ArrayList<String> readLicense(String strFilePath) {
        ArrayList<String> licenseList = new ArrayList<String>();
        String path = strFilePath;
        String content = "";
        File file = new File(path);
        if (file.isDirectory()) {
            Log.d((String)"TestFile", (String)"The File doesn't not exist.");
        } else {
            try {
                FileInputStream instream = new FileInputStream(file);
                if (instream != null) {
                    String line;
                    InputStreamReader inputreader = new InputStreamReader(instream);
                    BufferedReader buffreader = new BufferedReader(inputreader);
                    while ((line = buffreader.readLine()) != null) {
                        content = line;
                        licenseList.add(content);
                    }
                    ((InputStream)instream).close();
                }
            }
            catch (FileNotFoundException e) {
                Log.d((String)"TestFile", (String)"The File doesn't not exist.");
            }
            catch (IOException e) {
                Log.d((String)"TestFile", (String)e.getMessage());
            }
        }
        return licenseList;
    }

    public static String getSDPath() {
        File sdDir = null;
        boolean sdCardExist = Environment.getExternalStorageState().equals("mounted");
        if (sdCardExist) {
            sdDir = Environment.getExternalStorageDirectory();
        }
        if (sdDir != null) {
            return sdDir.toString();
        }
        return null;
    }

    public static boolean assetOpen(Context context, String modelPath) {
        boolean exist = false;
        if (context == null || TextUtils.isEmpty((CharSequence)modelPath)) {
            return false;
        }
        try {
            context.getAssets().open(modelPath);
            exist = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getModelContent(Context context, String modelName) {
        InputStream is = null;
        byte[] bytes = new byte[]{};
        File file = new File(modelName);
        if (file.exists()) {
            try {
                is = new FileInputStream(file);
                bytes = new byte[is.available()];
                is.read(bytes);
            }
            catch (FileNotFoundException fileNotFoundException) {
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        if (bytes.length > 0) {
            return bytes;
        }
        try {
            is = context.getResources().getAssets().open(modelName);
            bytes = new byte[is.available()];
            is.read(bytes);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException iOException) {}
        }
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap getBitmap(Context context, String imageName) {
        InputStream is = null;
        try {
            AssetManager assetManager = context.getResources().getAssets();
            is = assetManager.open(imageName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
            return bitmap;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public static byte[] getByteArrayFromAssets(Context context, String imageName) {
        byte[] bytes = null;
        try {
            InputStream is = context.getAssets().open(imageName);
            bytes = new byte[is.available()];
            is.read(bytes);
            is.close();
        }
        catch (IOException e) {
            Log.e((String)"zq", (String)("e-->" + e.getMessage()));
            e.printStackTrace();
        }
        return bytes;
    }
}

