/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk;

import android.content.Context;
import android.util.Log;
import com.baidu.idl.main.facesdk.FaceQueue;
import com.baidu.idl.main.facesdk.callback.Callback;
import com.baidu.idl.main.facesdk.model.BDFaceImageInstance;
import com.baidu.idl.main.facesdk.model.BDFaceInstance;
import com.baidu.idl.main.facesdk.model.BDFaceSDKCommon;
import com.baidu.idl.main.facesdk.utils.FileUitls;

public class FaceLive {
    private static final String TAG = FaceLive.class.getSimpleName();
    private BDFaceInstance bdFaceInstance;

    public FaceLive(BDFaceInstance thisBdFaceInstance) {
        if (thisBdFaceInstance == null) {
            return;
        }
        this.bdFaceInstance = thisBdFaceInstance;
    }

    public FaceLive() {
        this.bdFaceInstance = new BDFaceInstance();
        this.bdFaceInstance.getDefautlInstance();
    }

    public void initModel(final Context context, final String visModel, final String nirModel, final String depthModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceLive.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int statusVis = -1;
                byte[] visModelContent = FileUitls.getModelContent(context, visModel);
                if (visModelContent.length != 0 && (statusVis = FaceLive.this.nativeSilentLiveModelInit(instanceIndex, visModelContent, BDFaceSDKCommon.LiveType.BDFACE_SILENT_LIVE_TYPE_RGB.ordinal())) != 0) {
                    callback.onResponse(statusVis, "Vis \u6d3b\u4f53\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusNir = -1;
                byte[] nirModelContent = FileUitls.getModelContent(context, nirModel);
                if (nirModelContent.length != 0 && (statusNir = FaceLive.this.nativeSilentLiveModelInit(instanceIndex, nirModelContent, BDFaceSDKCommon.LiveType.BDFACE_SILENT_LIVE_TYPE_NIR.ordinal())) != 0) {
                    callback.onResponse(statusNir, "Nir \u6d3b\u4f53\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusDepth = -1;
                byte[] depthModelContent = FileUitls.getModelContent(context, depthModel);
                if (depthModelContent.length != 0 && (statusDepth = FaceLive.this.nativeSilentLiveModelInit(instanceIndex, depthModelContent, BDFaceSDKCommon.LiveType.BDFACE_SILENT_LIVE_TYPE_DEPTH.ordinal())) != 0) {
                    callback.onResponse(statusDepth, "Deep \u6d3b\u4f53\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                if (statusVis == 0 || statusNir == 0 || statusDepth == 0) {
                    callback.onResponse(0, "\u6d3b\u4f53\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                } else {
                    callback.onResponse(1, "\u6d3b\u4f53\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                }
                Log.e((String)"bdface", (String)"FaceLive initModel");
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public float silentLive(BDFaceSDKCommon.LiveType type, BDFaceImageInstance bdFaceImageInstance, float[] landmarks) {
        if (type == null || bdFaceImageInstance == null || landmarks == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return -1.0f;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1.0f;
        }
        return this.nativeSilentLive(instanceIndex, type.ordinal(), bdFaceImageInstance, landmarks);
    }

    public int uninitModel() {
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1;
        }
        return this.nativeUninitModel(this.bdFaceInstance.getIndex());
    }

    private native float nativeSilentLive(long var1, int var3, BDFaceImageInstance var4, float[] var5);

    private native int nativeSilentLiveModelInit(long var1, byte[] var3, int var4);

    private native int nativeUninitModel(long var1);
}

