/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk;

import android.content.Context;
import com.baidu.idl.main.facesdk.FaceInfo;
import com.baidu.idl.main.facesdk.FaceQueue;
import com.baidu.idl.main.facesdk.callback.Callback;
import com.baidu.idl.main.facesdk.model.BDFaceDriverMonitorInfo;
import com.baidu.idl.main.facesdk.model.BDFaceImageInstance;
import com.baidu.idl.main.facesdk.model.BDFaceInstance;
import com.baidu.idl.main.facesdk.utils.FileUitls;

public class FaceDriverMonitor {
    private BDFaceInstance bdFaceInstance;

    public FaceDriverMonitor(BDFaceInstance thisBdFaceInstance) {
        if (thisBdFaceInstance == null) {
            return;
        }
        this.bdFaceInstance = thisBdFaceInstance;
    }

    public FaceDriverMonitor() {
        this.bdFaceInstance = new BDFaceInstance();
        this.bdFaceInstance.getDefautlInstance();
    }

    public void initDriverMonitor(final Context context, final String driverMonitorModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceDriverMonitor.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    callback.onResponse(-1, "\u9a7e\u9a76\u884c\u4e3a\u76d1\u6d4b\u80fd\u529b\u52a0\u8f7d\u5931\u8d25 instanceIndex=0");
                    return;
                }
                int status = -1;
                byte[] modelContent = FileUitls.getModelContent(context, driverMonitorModel);
                if (modelContent.length != 0 && (status = FaceDriverMonitor.this.nativeDriverMonitorInit(instanceIndex, modelContent)) != 0) {
                    callback.onResponse(status, "\u9a7e\u9a76\u884c\u4e3a\u76d1\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                if (status == 0) {
                    callback.onResponse(0, "\u9a7e\u9a76\u884c\u4e3a\u76d1\u6d4b\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                } else {
                    callback.onResponse(1, "\u9a7e\u9a76\u884c\u4e3a\u76d1\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                }
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public int uninitDriverMonitor() {
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1;
        }
        return this.nativeUnInitDriverMonitor(instanceIndex);
    }

    public BDFaceDriverMonitorInfo driverMonitor(BDFaceImageInstance imageInstance, FaceInfo faceinfo) {
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L || imageInstance == null || faceinfo == null) {
            return null;
        }
        return this.nativeDriverMonitor(instanceIndex, imageInstance, faceinfo);
    }

    public native int nativeDriverMonitorInit(long var1, byte[] var3);

    public native int nativeUnInitDriverMonitor(long var1);

    public native BDFaceDriverMonitorInfo nativeDriverMonitor(long var1, BDFaceImageInstance var3, FaceInfo var4);
}

