/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk;

import android.content.Context;
import android.util.Log;
import com.baidu.idl.main.facesdk.FaceInfo;
import com.baidu.idl.main.facesdk.FaceQueue;
import com.baidu.idl.main.facesdk.callback.Callback;
import com.baidu.idl.main.facesdk.model.BDFaceDetectListConf;
import com.baidu.idl.main.facesdk.model.BDFaceImageInstance;
import com.baidu.idl.main.facesdk.model.BDFaceInstance;
import com.baidu.idl.main.facesdk.model.BDFaceSDKCommon;
import com.baidu.idl.main.facesdk.model.BDFaceSDKConfig;
import com.baidu.idl.main.facesdk.utils.FileUitls;
import java.util.concurrent.locks.ReentrantLock;

public class FaceDetect {
    private static final String TAG = FaceDetect.class.getSimpleName();
    private BDFaceInstance bdFaceInstance;
    private ReentrantLock lock = null;

    public FaceDetect(BDFaceInstance thisBdFaceInstance) {
        if (thisBdFaceInstance == null) {
            return;
        }
        this.bdFaceInstance = thisBdFaceInstance;
        this.lock = new ReentrantLock();
    }

    public FaceDetect() {
        this.bdFaceInstance = new BDFaceInstance();
        this.bdFaceInstance.getDefautlInstance();
        this.lock = new ReentrantLock();
    }

    public void initModel(final Context context, final String visModel, final String nirModel, final String alignModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceDetect.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int statusVis = -1;
                byte[] visModelContent = FileUitls.getModelContent(context, visModel);
                if (visModelContent.length != 0 && (statusVis = FaceDetect.this.nativeDetectModelInit(instanceIndex, visModelContent, BDFaceSDKCommon.DetectType.DETECT_VIS.ordinal())) != 0) {
                    callback.onResponse(statusVis, "Vis\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusNir = -1;
                byte[] nirModelContent = FileUitls.getModelContent(context, nirModel);
                if (nirModelContent.length != 0 && (statusNir = FaceDetect.this.nativeDetectModelInit(instanceIndex, nirModelContent, BDFaceSDKCommon.DetectType.DETECT_NIR.ordinal())) != 0) {
                    callback.onResponse(statusNir, "Nir\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusAlign = -1;
                byte[] alignModelContent = FileUitls.getModelContent(context, alignModel);
                if (alignModelContent.length != 0 && (statusAlign = FaceDetect.this.nativeAlignModelInit(instanceIndex, BDFaceSDKCommon.DetectType.DETECT_VIS.ordinal(), BDFaceSDKCommon.AlignType.BDFACE_ALIGN_TYPE_RGB_ACCURATE.ordinal(), alignModelContent)) != 0) {
                    callback.onResponse(statusAlign, "\u5bf9\u9f50\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusTrack = FaceDetect.this.nativeLoadTrack(instanceIndex, BDFaceSDKCommon.DetectType.DETECT_VIS.ordinal(), BDFaceSDKCommon.AlignType.BDFACE_ALIGN_TYPE_RGB_ACCURATE.ordinal());
                if (statusTrack != 0) {
                    callback.onResponse(statusTrack, "\u8ddf\u8e2a\u80fd\u529b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                if ((statusVis == 0 || statusNir == 0) && statusAlign == 0) {
                    callback.onResponse(0, "\u68c0\u6d4b\u5bf9\u9f50\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                } else {
                    callback.onResponse(1, "\u68c0\u6d4b\u5bf9\u9f50\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                }
                Log.e((String)TAG, (String)"FaceDetect initModel");
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public void initModel(final Context context, final String detectModel, final String alignModel, final BDFaceSDKCommon.DetectType detectType, final BDFaceSDKCommon.AlignType alignType, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceDetect.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int statusDetect = -1;
                byte[] visModelContent = FileUitls.getModelContent(context, detectModel);
                if (visModelContent.length != 0 && (statusDetect = FaceDetect.this.nativeDetectModelInit(instanceIndex, visModelContent, detectType.ordinal())) != 0) {
                    callback.onResponse(statusDetect, "\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusAlign = -1;
                byte[] alignModelContent = FileUitls.getModelContent(context, alignModel);
                if (alignModelContent.length != 0 && (statusAlign = FaceDetect.this.nativeAlignModelInit(instanceIndex, detectType.ordinal(), alignType.ordinal(), alignModelContent)) != 0) {
                    callback.onResponse(statusAlign, "\u5bf9\u9f50\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusTrack = FaceDetect.this.nativeLoadTrack(instanceIndex, detectType.ordinal(), alignType.ordinal());
                if (statusTrack != 0) {
                    callback.onResponse(statusTrack, "\u8ddf\u8e2a\u80fd\u529b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                if (statusDetect == 0 && statusAlign == 0) {
                    callback.onResponse(0, "\u68c0\u6d4b\u5bf9\u9f50\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                } else {
                    callback.onResponse(1, "\u68c0\u6d4b\u5bf9\u9f50\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                }
                Log.e((String)TAG, (String)"FaceDetect initModel");
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public void initQuality(final Context context, final String blurModel, final String occlurModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceDetect.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int statusblur = -1;
                byte[] blurModelContent = FileUitls.getModelContent(context, blurModel);
                if (blurModelContent.length != 0 && (statusblur = FaceDetect.this.nativeQualityModelInit(instanceIndex, blurModelContent, BDFaceSDKCommon.FaceQualityType.BLUR.ordinal())) != 0) {
                    callback.onResponse(statusblur, "\u6a21\u7cca\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusocclur = -1;
                byte[] occlurModelContent = FileUitls.getModelContent(context, occlurModel);
                if (occlurModelContent.length != 0 && (statusocclur = FaceDetect.this.nativeQualityModelInit(instanceIndex, occlurModelContent, BDFaceSDKCommon.FaceQualityType.OCCLUSION.ordinal())) != 0) {
                    callback.onResponse(statusocclur, "\u906e\u6321\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                if (statusblur == 0 || statusocclur == 0) {
                    callback.onResponse(0, "\u8d28\u91cf\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                } else {
                    callback.onResponse(1, "\u8d28\u91cf\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                }
                Log.e((String)TAG, (String)"FaceDetect initQuality");
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public void initAttrEmo(final Context context, final String atttibuteModel, final String emotionModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceDetect.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int statusAttr = -1;
                byte[] atttibuteModelContent = FileUitls.getModelContent(context, atttibuteModel);
                if (atttibuteModelContent.length != 0 && (statusAttr = FaceDetect.this.nativeAttributeModelInit(instanceIndex, atttibuteModelContent)) != 0) {
                    callback.onResponse(statusAttr, "\u5c5e\u6027\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusEmo = -1;
                byte[] emotionModelContent = FileUitls.getModelContent(context, emotionModel);
                if (emotionModelContent.length != 0 && (statusEmo = FaceDetect.this.nativeEmotionsModelInit(instanceIndex, emotionModelContent)) != 0) {
                    callback.onResponse(statusEmo, "\u60c5\u7eea\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                if (statusAttr == 0 || statusEmo == 0) {
                    callback.onResponse(0, "\u5c5e\u6027\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                } else {
                    callback.onResponse(1, "\u5c5e\u6027\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                }
                Log.e((String)"bdface", (String)"FaceAttributes initModel");
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public void initFaceClose(final Context context, final String eyecloseModel, final String mouthcloseModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceDetect.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int statusEyeClose = -1;
                byte[] eyecloseModelContent = FileUitls.getModelContent(context, eyecloseModel);
                if (eyecloseModelContent.length != 0 && (statusEyeClose = FaceDetect.this.nativeFaceCloseModelInit(instanceIndex, eyecloseModelContent, 0)) != 0) {
                    callback.onResponse(statusEyeClose, "\u773c\u775b\u95ed\u5408\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusMouthClose = -1;
                byte[] mouthcloseModelContent = FileUitls.getModelContent(context, mouthcloseModel);
                if (mouthcloseModelContent.length != 0 && (statusMouthClose = FaceDetect.this.nativeFaceCloseModelInit(instanceIndex, mouthcloseModelContent, 1)) != 0) {
                    callback.onResponse(statusMouthClose, "\u5634\u5df4\u95ed\u5408\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                if (statusEyeClose == 0 || statusMouthClose == 0) {
                    callback.onResponse(0, "\u95ed\u773c\u95ed\u5634\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                } else {
                    callback.onResponse(1, "\u95ed\u773c\u95ed\u5634\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                }
                Log.e((String)"bdface", (String)"FaceClose initModel");
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public void loadConfig(BDFaceSDKConfig config) {
        if (this.bdFaceInstance == null) {
            return;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return;
        }
        this.nativeLoadConfig(instanceIndex, config);
    }

    public FaceInfo[] detect(BDFaceSDKCommon.DetectType type, BDFaceImageInstance imageInstance) {
        if (type == null || imageInstance == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        if (!this.lock.tryLock()) {
            return null;
        }
        FaceInfo[] faceInfosTemp = this.nativeDetect(instanceIndex, type.ordinal(), BDFaceSDKCommon.AlignType.BDFACE_ALIGN_TYPE_RGB_ACCURATE.ordinal(), imageInstance);
        this.lock.unlock();
        return faceInfosTemp;
    }

    public FaceInfo[] detect(BDFaceSDKCommon.DetectType detectType, BDFaceSDKCommon.AlignType alignType, BDFaceImageInstance imageInstance, FaceInfo[] faceInfos, BDFaceDetectListConf bdFaceDetectListConfig) {
        if (detectType == null || imageInstance == null || alignType == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        if (!this.lock.tryLock()) {
            return null;
        }
        FaceInfo[] faceInfosTemp = this.nativeFlexibleDetect(instanceIndex, detectType.ordinal(), alignType.ordinal(), imageInstance, faceInfos, bdFaceDetectListConfig);
        this.lock.unlock();
        return faceInfosTemp;
    }

    public FaceInfo[] track(BDFaceSDKCommon.DetectType detectType, BDFaceImageInstance imageInstance) {
        if (detectType == null || imageInstance == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        if (!this.lock.tryLock()) {
            return null;
        }
        FaceInfo[] faceInfosTemp = this.nativeTrack(instanceIndex, detectType.ordinal(), imageInstance);
        this.lock.unlock();
        return faceInfosTemp;
    }

    public FaceInfo[] track(BDFaceSDKCommon.DetectType detectType, BDFaceSDKCommon.AlignType alignType, BDFaceImageInstance imageInstance) {
        if (detectType == null || imageInstance == null || alignType == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        FaceInfo[] faceInfosTemp = this.nativeFastTrack(instanceIndex, detectType.ordinal(), alignType.ordinal(), imageInstance);
        return faceInfosTemp;
    }

    public BDFaceImageInstance cropFace(BDFaceImageInstance imageInstance, float[] landmark) {
        if (imageInstance == null || landmark == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        return this.nativeCropFace(instanceIndex, imageInstance, landmark);
    }

    public int uninitModel() {
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1;
        }
        return this.nativeUninitModel(instanceIndex);
    }

    private native int nativeDetectModelInit(long var1, byte[] var3, int var4);

    private native int nativeAlignModelInit(long var1, int var3, int var4, byte[] var5);

    private native int nativeLoadTrack(long var1, int var3, int var4);

    private native int nativeQualityModelInit(long var1, byte[] var3, int var4);

    private native int nativeAttributeModelInit(long var1, byte[] var3);

    private native int nativeEmotionsModelInit(long var1, byte[] var3);

    private native int nativeFaceCloseModelInit(long var1, byte[] var3, int var4);

    private native void nativeLoadConfig(long var1, BDFaceSDKConfig var3);

    private native FaceInfo[] nativeTrack(long var1, int var3, BDFaceImageInstance var4);

    private native FaceInfo[] nativeFastTrack(long var1, int var3, int var4, BDFaceImageInstance var5);

    private native FaceInfo[] nativeDetect(long var1, int var3, int var4, BDFaceImageInstance var5);

    private native FaceInfo[] nativeFlexibleDetect(long var1, int var3, int var4, BDFaceImageInstance var5, FaceInfo[] var6, BDFaceDetectListConf var7);

    private native BDFaceImageInstance nativeCropFace(long var1, BDFaceImageInstance var3, float[] var4);

    private native int nativeUninitModel(long var1);
}

