/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.idl.main.facesdk.FaceQueue;
import com.baidu.idl.main.facesdk.callback.Callback;
import com.baidu.idl.main.facesdk.license.BDFaceLicenseAuthInfo;
import com.baidu.idl.main.facesdk.license.BDFaceLicenseLocalInfo;
import com.baidu.idl.main.facesdk.model.BDFaceSDKCommon;
import com.baidu.idl.main.facesdk.statistic.PostDeviceInfo;
import com.baidu.idl.main.facesdk.utils.FileUitls;
import com.baidu.idl.main.facesdk.utils.PreferencesUtil;
import com.baidu.idl.main.facesdk.utils.ZipUtils;
import com.baidu.vis.unified.license.AndroidLicenser;
import com.baidu.vis.unified.license.BDLicenseAuthInfo;
import com.baidu.vis.unified.license.BDLicenseLocalInfo;
import com.baidu.vis.unified.license.HttpStatus;
import com.baidu.vis.unified.license.HttpUtils;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class FaceAuth {
    private static final String TAG = "FaceSDK";
    private static final String LICENSE_FILE_NAME = "idl-license.face-android";
    private static int ALGORITHM_ID = 3;

    public void setActiveLog(BDFaceSDKCommon.BDFaceLogInfo logInfo, int isLog) {
        this.nativeSetActiveLog(logInfo.ordinal(), isLog);
    }

    public void setCoreConfigure(BDFaceSDKCommon.BDFaceCoreRunMode runMode, int coreNum) {
        this.nativeSetCoreConfigure(runMode.ordinal(), coreNum);
    }

    public String getDeviceId(Context context) {
        return AndroidLicenser.getDeviceId((Context)context.getApplicationContext());
    }

    public BDFaceLicenseLocalInfo getLocalInfo(Context context) {
        BDLicenseLocalInfo bdLocalInfo = AndroidLicenser.getInstance().authGetLocalInfo(context, ALGORITHM_ID);
        BDFaceLicenseLocalInfo bdFaceLocalInfo = new BDFaceLicenseLocalInfo();
        bdFaceLocalInfo.algorithmId = bdLocalInfo.algorithmId;
        bdFaceLocalInfo.deviceId = bdLocalInfo.deviceId;
        bdFaceLocalInfo.fingerVersion = bdLocalInfo.fingerVersion;
        bdFaceLocalInfo.licenseSdkVersion = bdLocalInfo.licenseSdkVersion;
        bdFaceLocalInfo.licenseKey = bdLocalInfo.licenseKey;
        bdFaceLocalInfo.md5 = bdLocalInfo.md5;
        bdFaceLocalInfo.packageName = bdLocalInfo.packageName;
        return bdFaceLocalInfo;
    }

    public BDFaceLicenseAuthInfo getAuthInfo(Context context) {
        BDLicenseAuthInfo bdAuthInfo = AndroidLicenser.getInstance().authGetAuthInfo(context, ALGORITHM_ID);
        BDFaceLicenseAuthInfo bdFaceAuthInfo = new BDFaceLicenseAuthInfo();
        bdFaceAuthInfo.algorithmId = bdAuthInfo.algorithmId;
        bdFaceAuthInfo.deviceId = bdAuthInfo.deviceId;
        bdFaceAuthInfo.expireTime = bdAuthInfo.expireTime;
        bdFaceAuthInfo.functionList = bdAuthInfo.functionList;
        bdFaceAuthInfo.licenseKey = bdAuthInfo.licenseKey;
        bdFaceAuthInfo.md5 = bdAuthInfo.md5;
        bdFaceAuthInfo.packageName = bdAuthInfo.packageName;
        return bdFaceAuthInfo;
    }

    public void initLicense(final Context context, final String licenseID, final String licenseFileName, final boolean isRemote, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                if (TextUtils.isEmpty((CharSequence)licenseID) || TextUtils.isEmpty((CharSequence)licenseFileName)) {
                    callback.onResponse(2, "license \u5173\u952e\u5b57\u4e3a\u7a7a");
                    return;
                }
                AndroidLicenser licenser = AndroidLicenser.getInstance();
                AndroidLicenser.ErrorCode errorCode = licenser.authFromFile(context, licenseID, licenseFileName, isRemote, ALGORITHM_ID);
                if (errorCode != AndroidLicenser.ErrorCode.SUCCESS) {
                    BDLicenseLocalInfo info = licenser.authGetLocalInfo(context, ALGORITHM_ID);
                    if (info != null) {
                        Log.i((String)FaceAuth.TAG, (String)info.toString());
                    }
                } else {
                    int status = FaceAuth.this.nativeCreatInstance();
                    Log.v((String)FaceAuth.TAG, (String)("bdface_create_instance status " + status));
                }
                String errMsg = licenser.getErrorMsg(ALGORITHM_ID);
                callback.onResponse(errorCode.ordinal(), errMsg);
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public void initLicenseOnLine(final Context context, final String licenseID, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                PreferencesUtil.initPrefs(context);
                String statics = PreferencesUtil.getString("statics", "");
                if (TextUtils.isEmpty((CharSequence)statics)) {
                    PostDeviceInfo.uploadDeviceInfo(context, new Callback(){

                        @Override
                        public void onResponse(int code, String response) {
                            if (code == 0) {
                                PreferencesUtil.putString("statics", "ok");
                            }
                        }
                    });
                }
                if (TextUtils.isEmpty((CharSequence)licenseID) || TextUtils.isEmpty((CharSequence)FaceAuth.LICENSE_FILE_NAME)) {
                    callback.onResponse(2, "license \u5173\u952e\u5b57\u4e3a\u7a7a");
                    return;
                }
                AndroidLicenser licenser = AndroidLicenser.getInstance();
                AndroidLicenser.ErrorCode errorCode = licenser.authFromFile(context, licenseID, FaceAuth.LICENSE_FILE_NAME, false, ALGORITHM_ID);
                Log.e((String)FaceAuth.TAG, (String)("errCode = " + errorCode));
                if (errorCode == AndroidLicenser.ErrorCode.SUCCESS) {
                    int status = FaceAuth.this.nativeCreatInstance();
                    Log.v((String)FaceAuth.TAG, (String)("bdface_create_instance status " + status));
                    String errMsg = licenser.getErrorMsg(ALGORITHM_ID);
                    callback.onResponse(errorCode.ordinal(), errMsg);
                    return;
                }
                String device = AndroidLicenser.getDeviceId((Context)context.getApplicationContext());
                String url = "https://ai.baidu.com/activation/key/activate";
                String paramStr = null;
                try {
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("deviceId", (Object)device);
                    jsonObject.put("key", (Object)licenseID);
                    jsonObject.put("platformType", 2);
                    jsonObject.put("version", 5);
                    paramStr = jsonObject.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                HttpStatus httpStatus = HttpUtils.requestPost((String)url, paramStr, (String)"application/json", (String)FaceAuth.TAG);
                if (httpStatus == null) {
                    callback.onResponse(-1, "\u5728\u7ebf\u6fc0\u6d3b\u5931\u8d25");
                    return;
                }
                String response = httpStatus.responseStr;
                try {
                    JSONObject json = new JSONObject(response);
                    int jsonErrorCode = json.optInt("error_code");
                    if (jsonErrorCode != 0) {
                        String errorMsg = json.optString("error_msg");
                        Log.i((String)FaceAuth.TAG, (String)("error_msg->" + errorMsg));
                        callback.onResponse(-1, errorMsg);
                    } else {
                        String[] licenses;
                        String license;
                        JSONObject result = json.optJSONObject("result");
                        if (result != null && !TextUtils.isEmpty((CharSequence)(license = result.optString("license"))) && (licenses = license.split(",")) != null && licenses.length == 2) {
                            PreferencesUtil.putString("activate_online_key", licenseID);
                            errorCode = licenser.authFromMemory(context, licenseID, licenses, FaceAuth.LICENSE_FILE_NAME, ALGORITHM_ID);
                            if (errorCode != AndroidLicenser.ErrorCode.SUCCESS) {
                                BDLicenseLocalInfo info = licenser.authGetLocalInfo(context, ALGORITHM_ID);
                                if (info != null) {
                                    Log.i((String)FaceAuth.TAG, (String)info.toString());
                                }
                            } else {
                                int status = FaceAuth.this.nativeCreatInstance();
                                Log.v((String)FaceAuth.TAG, (String)("bdface_create_instance status " + status));
                            }
                            String errMsg = licenser.getErrorMsg(ALGORITHM_ID);
                            callback.onResponse(errorCode.ordinal(), errMsg);
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                Log.i((String)FaceAuth.TAG, (String)("netRequest->" + response));
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public void initLicenseOffLine(final Context context, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String path;
                String sdCardDir;
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                PreferencesUtil.initPrefs(context);
                String statics = PreferencesUtil.getString("statics", "");
                if (TextUtils.isEmpty((CharSequence)statics)) {
                    PostDeviceInfo.uploadDeviceInfo(context, new Callback(){

                        @Override
                        public void onResponse(int code, String response) {
                            if (code == 0) {
                                PreferencesUtil.putString("statics", "ok");
                            }
                        }
                    });
                }
                if (FileUitls.fileIsExists(sdCardDir = (path = FileUitls.getSDPath()) + "/License.zip")) {
                    boolean isZipSuccess = ZipUtils.unzip(sdCardDir);
                    if (isZipSuccess) {
                        String keyPath = path + "/license.key";
                        String offLicenseKey = FileUitls.readFile(keyPath);
                        PreferencesUtil.putString("activate_offline_key", offLicenseKey);
                        AndroidLicenser licenser = AndroidLicenser.getInstance();
                        AndroidLicenser.ErrorCode errorCode = licenser.authFromFile(context, offLicenseKey, FaceAuth.LICENSE_FILE_NAME, false, ALGORITHM_ID);
                        if (errorCode == AndroidLicenser.ErrorCode.SUCCESS) {
                            int status = FaceAuth.this.nativeCreatInstance();
                            Log.v((String)FaceAuth.TAG, (String)("bdface_create_instance status " + status));
                            String errMsg = licenser.getErrorMsg(ALGORITHM_ID);
                            callback.onResponse(errorCode.ordinal(), errMsg);
                            return;
                        }
                        String licensePath = path + "/license.ini";
                        ArrayList<String> licenseList = FileUitls.readLicense(licensePath);
                        String[] licenses = licenseList.toArray(new String[licenseList.size()]);
                        if (licenses != null && licenses.length == 2) {
                            errorCode = licenser.authFromMemory(context, offLicenseKey, licenses, FaceAuth.LICENSE_FILE_NAME, ALGORITHM_ID);
                            if (errorCode != AndroidLicenser.ErrorCode.SUCCESS) {
                                BDLicenseLocalInfo info = licenser.authGetLocalInfo(context, ALGORITHM_ID);
                                if (info != null) {
                                    Log.i((String)FaceAuth.TAG, (String)info.toString());
                                }
                            } else {
                                int status = FaceAuth.this.nativeCreatInstance();
                                Log.v((String)FaceAuth.TAG, (String)("bdface_create_instance status " + status));
                            }
                            String errMsg = licenser.getErrorMsg(ALGORITHM_ID);
                            callback.onResponse(errorCode.ordinal(), errMsg);
                        }
                    } else {
                        callback.onResponse(-1, "license \u6587\u4ef6\u89e3\u538b\u5931\u8d25");
                        Log.i((String)FaceAuth.TAG, (String)"file_state->license zip failed");
                    }
                } else {
                    callback.onResponse(-1, "license \u6587\u4ef6\u4e0d\u5b58\u5728!");
                    Log.i((String)FaceAuth.TAG, (String)"file_state->file not found");
                }
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public void initLicenseBatchLine(final Context context, final String licenseKey, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                } else {
                    PreferencesUtil.initPrefs(context);
                    String statics = PreferencesUtil.getString("statics", "");
                    if (TextUtils.isEmpty((CharSequence)statics)) {
                        PostDeviceInfo.uploadDeviceInfo(context, new Callback(){

                            @Override
                            public void onResponse(int code, String response) {
                                if (code == 0) {
                                    PreferencesUtil.putString("statics", "ok");
                                }
                            }
                        });
                    }
                    if (!TextUtils.isEmpty((CharSequence)licenseKey) && !TextUtils.isEmpty((CharSequence)FaceAuth.LICENSE_FILE_NAME)) {
                        AndroidLicenser licenser = AndroidLicenser.getInstance();
                        AndroidLicenser.ErrorCode errorCode = licenser.authFromFile(context, licenseKey, FaceAuth.LICENSE_FILE_NAME, true, ALGORITHM_ID);
                        if (errorCode != AndroidLicenser.ErrorCode.SUCCESS) {
                            BDLicenseLocalInfo info = licenser.authGetLocalInfo(context, ALGORITHM_ID);
                            if (info != null) {
                                Log.i((String)FaceAuth.TAG, (String)info.toString());
                            }
                        } else {
                            int status = FaceAuth.this.nativeCreatInstance();
                            Log.v((String)FaceAuth.TAG, (String)("bdface_create_instance status " + status));
                        }
                        String errMsg = licenser.getErrorMsg(ALGORITHM_ID);
                        callback.onResponse(errorCode.ordinal(), errMsg);
                    } else {
                        callback.onResponse(2, "license \u5173\u952e\u5b57\u4e3a\u7a7a");
                    }
                }
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    private native int nativeCreatInstance();

    private native void nativeSetActiveLog(int var1, int var2);

    private native void nativeSetCoreConfigure(int var1, int var2);

    static {
        try {
            System.loadLibrary("bdface_sdk");
            System.loadLibrary("bd_unifylicense");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

