/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.facesdk;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import com.baidu.idl.facesdk.BDFaceUtils;
import com.baidu.idl.facesdk.FaceInfo;
import com.baidu.idl.facesdk.FaceVerifyData;
import com.baidu.idl.license.AndroidLicenser;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Pattern;

public class FaceSDK {
    private static final String TAG = FaceSDK.class.getSimpleName();
    private static int mAuthorityStatus = AndroidLicenser.ErrorCode.LICENSE_INIT_ERROR.ordinal();

    public static synchronized void initLicense(final Context context, final String licenseID, final String licenseFileName, final boolean remoteAuthorize) {
        if (context != null) {
            File dir = context.getDir("FaceSDKLibs", 0);
            File faceSdkLib = new File(dir.getAbsolutePath() + File.separator + "libFaceSDK.so");
            File faceSdkLicenseLib = new File(dir.getAbsolutePath() + File.separator + "libbaidu_license.so");
            if (faceSdkLib.exists() && faceSdkLicenseLib.exists()) {
                Log.e((String)TAG, (String)"Load library from private space");
                System.load(faceSdkLicenseLib.getAbsolutePath());
                System.load(faceSdkLib.getAbsolutePath());
                Log.e((String)TAG, (String)"Load facesdk library from private space succeed");
            } else {
                Log.e((String)TAG, (String)"Load library from assets space");
                System.loadLibrary("baidu_license");
                System.loadLibrary("FaceSDK");
                Log.e((String)TAG, (String)"Load facesdk library from assets space succeed");
            }
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Log.e((String)TAG, (String)"init license");
                        if (!"".equals(licenseID) && !"".equals(licenseFileName)) {
                            AndroidLicenser licenser = AndroidLicenser.getInstance();
                            licenser.init(context, licenseID, licenseFileName, 3);
                            licenser.is_remote_authorize = remoteAuthorize;
                            mAuthorityStatus = licenser.authenticate(context);
                        }
                        Log.e((String)TAG, (String)("license  status  " + mAuthorityStatus));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }).start();
            int numOfCpuCore = FaceSDK.getNumCores();
            int numOfThreads = numOfCpuCore > 1 ? numOfCpuCore / 2 : 1;
            FaceSDK.setNumberOfThreads(numOfThreads);
        }
    }

    public static int getAuthorityStatus() {
        return mAuthorityStatus;
    }

    public static synchronized void initModel(Context context) {
        if (context != null) {
            if (BDFaceUtils.hasModel(context, "align_model.binary")) {
                FaceSDK.AlignModelInit(context.getAssets(), "align_model.binary", "", AlignMethodType.CDNN.ordinal());
            }
            if (BDFaceUtils.hasModel(context, "facedetect.binary")) {
                FaceSDK.DetectModelInit(context.getAssets(), "facedetect.binary", DetectMethodType.CNN.ordinal());
            }
            if (BDFaceUtils.hasModel(context, "small_detect.model")) {
                FaceSDK.DetectModelInit(context.getAssets(), "small_detect.model", DetectMethodType.NIR.ordinal());
            }
            if (BDFaceUtils.hasModel(context, "score.binary")) {
                FaceSDK.ScoreModelInit(context.getAssets(), "score.binary", "", DetectMethodType.CNN.ordinal());
            }
            if (BDFaceUtils.hasModel(context, "blur.binary")) {
                FaceSDK.imgQualityModelInit(context.getAssets(), "blur.binary", "", QualityModelType.QUALITY_BLUR.ordinal());
            }
            if (BDFaceUtils.hasModel(context, "occlu.binary")) {
                FaceSDK.imgQualityModelInit(context.getAssets(), "occlu.binary", "", QualityModelType.QUALITY_OCCLUSION.ordinal());
            }
        }
    }

    public static FaceInfo[] run_detect(int[] img, int rows, int cols, ImgType imgType, DetectMethodType methodType, int minFaceSize) {
        FaceInfo[] info = FaceSDK.detect(img, rows, cols, imgType.ordinal(), methodType.ordinal(), minFaceSize);
        return info;
    }

    public static int run_align(int[] img, int rows, int cols, ImgType imgType, AlignMethodType methodType, int[] face, int[] shape, int[] nPoint, float[] score) {
        int result = -1;
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        result = FaceSDK.align(img, rows, cols, imgType.ordinal(), methodType.ordinal(), face, shape, nPoint, score);
        return result;
    }

    public static int run_fineAlign(int[] img, int rows, int cols, ImgType imgType, int[] shape, int[] nPoint) {
        int result = -1;
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        result = FaceSDK.fineAlign(img, rows, cols, imgType.ordinal(), shape, nPoint);
        return result;
    }

    private static int run_tracking(int[] img, int rows, int cols, ImgType imgType, AlignMethodType methodType, int[] shape, int[] nPoint, float[] score) {
        int result = -1;
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        result = FaceSDK.tracking(img, rows, cols, imgType.ordinal(), methodType.ordinal(), shape, nPoint, score);
        return result;
    }

    public static int run_liveness(int[] img, int rows, int cols, ImgType imgType, LivenessMethodType methodType, int[] shape, int[] nPoint, LivenessAction flag, int[] status) {
        int result = -1;
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        result = FaceSDK.liveness(img, rows, cols, imgType.ordinal(), methodType.ordinal(), shape, nPoint, flag.ordinal(), status);
        return result;
    }

    public static int run_parsing(int[] img, int rows, int cols, ImgType imgType, ParsMethodType methodType, int[] shape, int nPoint, byte[] classMap) {
        int result = -1;
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        result = FaceSDK.parsing(img, rows, cols, imgType.ordinal(), methodType.ordinal(), shape, nPoint, classMap);
        return result;
    }

    public static int run_headPoseEstimation(int[] shape, int[] nPoint, double[] pose) {
        int result = FaceSDK.headPoseEstimation(shape, nPoint[0], pose);
        return result;
    }

    public static int run_cropFaceImg(int[] img, int rows, int cols, ImgType imgType, int[] shape, int nPoint, int faceRows, int faceCols, int[] faceImg, int[] faceShape) {
        int result = -1;
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        result = FaceSDK.cropFaceImg(img, rows, cols, imgType.ordinal(), shape, nPoint, faceRows, faceCols, faceImg, faceShape);
        return result;
    }

    public static int run_imgQuality(int[] img, int rows, int cols, int imgType, int[] shape, int nPoint, float[] bluriness, int[] illum, float[] occlusion, int[] nOccluPart) {
        int result = -1;
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        result = FaceSDK.imgQuality(img, rows, cols, imgType, shape, nPoint, bluriness, illum, occlusion, nOccluPart);
        return result;
    }

    public static int superResolutionMoelInit(Context context) {
        if (context == null || !BDFaceUtils.hasModel(context, "super_resolution.model_fix")) {
            return -1;
        }
        return FaceSDK.superResolutionMoelInit(context.getAssets(), "super_resolution.model_fix");
    }

    public static FaceVerifyData superResolution(int[] img, int row, int cols, ImgType imageType) {
        if (!FaceSDK.checkParameter(img, row, cols)) {
            return null;
        }
        return FaceSDK.superResolution(img, row, cols, imageType.ordinal());
    }

    public static int removeTextureModelInit(Context context) {
        if (context == null || !BDFaceUtils.hasModel(context, "remove_texture.model_fix")) {
            return -1;
        }
        return FaceSDK.removeTextureModelInit(context.getAssets(), "remove_texture.model_fix");
    }

    public static FaceVerifyData removeTexture(int[] img, int row, int cols, ImgType imageType) {
        if (!FaceSDK.checkParameter(img, row, cols)) {
            return null;
        }
        return FaceSDK.removeTexture(img, row, cols, imageType.ordinal());
    }

    public static String getVersion() {
        return "3.2.2.0";
    }

    private static int getNumCores() {
        try {
            File dir = new File("/sys/devices/system/cpu/");
            class CpuFilter
            implements FileFilter {
                CpuFilter() {
                }

                @Override
                public boolean accept(File pathname) {
                    return Pattern.matches("cpu[0-9]+", pathname.getName());
                }
            }
            File[] files = dir.listFiles(new CpuFilter());
            return files.length;
        }
        catch (Exception e) {
            return 1;
        }
    }

    public static boolean checkParameter(Object img, int rows, int cols) {
        return img != null && rows > 0 && cols > 0;
    }

    public static int livenessSilentInit(Context context, LivenessTypeId liveType) {
        int result = -1;
        if (context == null) {
            return result;
        }
        if (liveType == LivenessTypeId.LIVEID_IR && BDFaceUtils.hasModel(context, "liveness_nir_82-20180211.model")) {
            result = FaceSDK.livenessSilentInit(context.getAssets(), liveType.ordinal(), "liveness_nir_82-20180211.model");
        } else if (liveType == LivenessTypeId.LIVEID_DEPTH && BDFaceUtils.hasModel(context, "liveness_depth_96-15_1_5.model")) {
            result = FaceSDK.livenessSilentInit(context.getAssets(), liveType.ordinal(), "liveness_depth_96-15_1_5.model");
        } else if (liveType == LivenessTypeId.LIVEID_VIS && BDFaceUtils.hasModel(context, "liveness_vis_101.model")) {
            result = FaceSDK.livenessSilentInit(context.getAssets(), liveType.ordinal(), "liveness_vis_101.model");
        }
        return result;
    }

    public static float run_livenessSilentPredict(LivenessTypeId liveType, int[] img, int rows, int cols, int imgType, int[] shape) {
        float result = -1.0f;
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        result = FaceSDK.livenessSilentPredict(liveType.ordinal(), img, rows, cols, imgType, shape);
        return result;
    }

    public static float run_livenessSilentPredictByte(LivenessTypeId liveType, byte[] img, int rows, int cols, int imgType, int[] shape) {
        float result = -1.0f;
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        result = FaceSDK.livenessSilentPredictByte(liveType.ordinal(), img, rows, cols, imgType, shape);
        return result;
    }

    public static native int setPerfLogFlag(int var0);

    public static native int setValueLogFlag(int var0);

    public static native int setNumberOfThreads(int var0);

    public static native int getARGBFromYUVimg(byte[] var0, int[] var1, int var2, int var3, int var4, int var5);

    public static native int imgQuality(int[] var0, int var1, int var2, int var3, int[] var4, int var5, float[] var6, int[] var7, float[] var8, int[] var9);

    private static native int AlignModelInit(AssetManager var0, String var1, String var2, int var3);

    private static native int DetectModelInit(AssetManager var0, String var1, int var2);

    private static native int ScoreModelInit(AssetManager var0, String var1, String var2, int var3);

    private static native int ParsingModelInit(AssetManager var0, String var1, String var2, int var3);

    private static native int imgQualityModelInit(AssetManager var0, String var1, String var2, int var3);

    private static native FaceInfo[] detect(int[] var0, int var1, int var2, int var3, int var4, int var5);

    private static native int align(int[] var0, int var1, int var2, int var3, int var4, int[] var5, int[] var6, int[] var7, float[] var8);

    private static native int fineAlign(int[] var0, int var1, int var2, int var3, int[] var4, int[] var5);

    private static native int tracking(int[] var0, int var1, int var2, int var3, int var4, int[] var5, int[] var6, float[] var7);

    private static native int liveness(int[] var0, int var1, int var2, int var3, int var4, int[] var5, int[] var6, int var7, int[] var8);

    private static native int parsing(int[] var0, int var1, int var2, int var3, int var4, int[] var5, int var6, byte[] var7);

    private static native int headPoseEstimation(int[] var0, int var1, double[] var2);

    private static native int cropFaceImg(int[] var0, int var1, int var2, int var3, int[] var4, int var5, int var6, int var7, int[] var8, int[] var9);

    private static native int livenessSilentInit(AssetManager var0, int var1, String var2);

    private static native float livenessSilentPredict(int var0, int[] var1, int var2, int var3, int var4, int[] var5);

    private static native float livenessSilentPredictByte(int var0, byte[] var1, int var2, int var3, int var4, int[] var5);

    private static native int superResolutionMoelInit(AssetManager var0, String var1);

    private static native FaceVerifyData superResolution(int[] var0, int var1, int var2, int var3);

    private static native int removeTextureModelInit(AssetManager var0, String var1);

    private static native FaceVerifyData removeTexture(int[] var0, int var1, int var2, int var3);

    public static enum LivenessTypeId {
        LIVEID_IR,
        LIVEID_DEPTH,
        LIVEID_VIS;

    }

    public static enum RecognizeType {
        RECOGNIZE_ID_PHOTO,
        RECOGNIZE_LIVE,
        RECOGNIZE_NIR;

    }

    public static enum LivenessAction {
        RESET,
        ADD_ONE_FRAME;

    }

    public static enum LivenessMethodType {
        EYE_BLINK,
        MOUTH_MOTION,
        HEAD_POSE,
        ALL;

    }

    public static enum ParsMethodType {
        NOT_USE,
        CLASS_NUM_3,
        CLASS_NUM_7,
        CLASS_NUM_10;

    }

    public static enum QualityModelType {
        QUALITY_NOT_USE,
        QUALITY_BLUR,
        QUALITY_OCCLUSION;

    }

    public static enum AlignMethodType {
        SDM,
        CDNN,
        SDM_7PTS,
        SDM_15PTS;

    }

    public static enum DetectMethodType {
        BOOST,
        CNN,
        NIR;

    }

    public static enum ImgType {
        ARGB;

    }
}

