/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.facesdk;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import com.baidu.idl.facesdk.BDFaceUtils;
import com.baidu.idl.facesdk.FaceInfo;
import com.baidu.idl.facesdk.FaceSDK;
import java.util.HashMap;
import java.util.Map;

public class FaceRecognize {
    private static final String TAG = "FaceRecognize";
    private Context context;
    private boolean isInitModel = false;
    private Map<FaceSDK.RecognizeType, Boolean> abilities = new HashMap<FaceSDK.RecognizeType, Boolean>();

    public FaceRecognize(Context context) {
        this.context = context;
    }

    public void initModel(FaceSDK.RecognizeType recognizeType) {
        if (this.context != null) {
            if (recognizeType == FaceSDK.RecognizeType.RECOGNIZE_ID_PHOTO && BDFaceUtils.hasModel(this.context, "finance_rec_1p.dat_fix")) {
                this.recognizeModelInit(this.context.getAssets(), "finance_rec_1p.dat_fix", FaceSDK.RecognizeType.RECOGNIZE_ID_PHOTO.ordinal());
                this.abilities.put(FaceSDK.RecognizeType.RECOGNIZE_ID_PHOTO, true);
            }
            if (recognizeType == FaceSDK.RecognizeType.RECOGNIZE_LIVE && BDFaceUtils.hasModel(this.context, "recognize_model.dat")) {
                this.recognizeModelInit(this.context.getAssets(), "recognize_model.dat", FaceSDK.RecognizeType.RECOGNIZE_LIVE.ordinal());
                this.abilities.put(FaceSDK.RecognizeType.RECOGNIZE_LIVE, true);
            }
            if (recognizeType == FaceSDK.RecognizeType.RECOGNIZE_NIR && BDFaceUtils.hasModel(this.context, "safe_1pfc1_nobn_100_32bit.kv")) {
                this.recognizeModelInit(this.context.getAssets(), "safe_1pfc1_nobn_100_32bit.kv", FaceSDK.RecognizeType.RECOGNIZE_NIR.ordinal());
                this.abilities.put(FaceSDK.RecognizeType.RECOGNIZE_NIR, true);
            }
        }
    }

    public int extractFeature(int[] img, int rows, int cols, FaceSDK.ImgType imgType, byte[] feature, int[] landmarks, FaceSDK.RecognizeType recognize_type) {
        int result = -1;
        if (!this.abilities.containsKey((Object)recognize_type)) {
            Log.e((String)TAG, (String)("not success init " + (Object)((Object)recognize_type)));
            return result;
        }
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        if (landmarks == null) {
            return result;
        }
        if (feature == null || feature.length != 2048) {
            return result;
        }
        result = this.extractFeature(img, rows, cols, imgType.ordinal(), feature, landmarks, 1, recognize_type.ordinal());
        return result;
    }

    public int extractFeature(int[] img, int rows, int cols, FaceSDK.ImgType imgType, int minFaceSize, byte[] feature, FaceSDK.RecognizeType recognize_type) {
        int result = -1;
        if (!this.abilities.containsKey((Object)recognize_type)) {
            Log.e((String)TAG, (String)("not success init " + (Object)((Object)recognize_type)));
            return result;
        }
        if (!FaceSDK.checkParameter(img, rows, cols)) {
            return result;
        }
        if (feature == null || feature.length != 2048) {
            return result;
        }
        if (!this.isInitModel) {
            if (this.context == null) {
                return result;
            }
            FaceSDK.initModel(this.context);
            this.isInitModel = true;
        }
        FaceInfo[] faces = null;
        long alltime = System.currentTimeMillis();
        long time = System.currentTimeMillis();
        try {
            if (minFaceSize == 0) {
                minFaceSize = 100;
            }
            Log.e((String)TAG, (String)"detect start");
            faces = recognize_type == FaceSDK.RecognizeType.RECOGNIZE_LIVE || recognize_type == FaceSDK.RecognizeType.RECOGNIZE_ID_PHOTO ? FaceSDK.run_detect(img, rows, cols, imgType, FaceSDK.DetectMethodType.CNN, minFaceSize) : FaceSDK.run_detect(img, rows, cols, imgType, FaceSDK.DetectMethodType.NIR, minFaceSize);
            Log.e((String)TAG, (String)("detect end " + (System.currentTimeMillis() - time)));
        }
        catch (Exception var21) {
            Log.i((String)TAG, (String)"FaceSDK: You need to apply for the authorization to use the facesdk");
            var21.printStackTrace();
        }
        int max_width = 0;
        int max_id = 0;
        if (faces != null && faces.length > 0) {
            time = System.currentTimeMillis();
            for (int i = 0; i < faces.length; ++i) {
                if (faces[i].mWidth <= max_width) continue;
                max_id = i;
                max_width = faces[i].mWidth;
            }
            int[] face_t = new int[]{faces[max_id].mCenter_x, faces[max_id].mCenter_y, faces[max_id].mWidth, faces[max_id].mAngle};
            int[] shape = new int[144];
            int[] nPoint = new int[]{0};
            float[] score = new float[]{0.0f};
            try {
                Log.e((String)TAG, (String)"align start");
                FaceSDK.run_align(img, rows, cols, imgType, FaceSDK.AlignMethodType.CDNN, face_t, shape, nPoint, score);
                Log.e((String)TAG, (String)("align end " + (System.currentTimeMillis() - time)));
            }
            catch (Exception var20) {
                Log.i((String)TAG, (String)"You need to apply for the authorization to use the facesdk");
                var20.printStackTrace();
            }
            time = System.currentTimeMillis();
            int ret = -1;
            try {
                Log.e((String)TAG, (String)"feature start");
                ret = this.extractFeature(img, rows, cols, imgType.ordinal(), feature, shape, 1, recognize_type.ordinal());
                Log.e((String)TAG, (String)("feature end " + (System.currentTimeMillis() - time)));
            }
            catch (Exception var19) {
                Log.i((String)TAG, (String)"You need to apply for the authorization to use the facesdk");
                var19.printStackTrace();
            }
            Log.e((String)TAG, (String)("all time " + (System.currentTimeMillis() - alltime)));
            return ret;
        }
        return -1;
    }

    public float getFaceFeatureDistance(byte[] firstFaceFeature, byte[] secondFaceFeature) {
        if (firstFaceFeature == null || secondFaceFeature == null) {
            return -1.0f;
        }
        if (firstFaceFeature.length != secondFaceFeature.length) {
            return -1.0f;
        }
        float result = this.getConsineDistance(firstFaceFeature, secondFaceFeature);
        if (Float.isNaN(result)) {
            return -1.0f;
        }
        return result;
    }

    public float getFaceSimilarity(byte[] firstFaceFeature, byte[] secondFaceFeature, FaceSDK.RecognizeType recognizeType) {
        if (recognizeType == FaceSDK.RecognizeType.RECOGNIZE_ID_PHOTO || recognizeType == FaceSDK.RecognizeType.RECOGNIZE_NIR) {
            if (BDFaceUtils.hasModel(this.context, "finance_rec_1p-compare.cfg")) {
                this.scoreMapInit(this.context.getAssets(), "finance_rec_1p-compare.cfg", recognizeType.ordinal());
                return this.getFaceSimilarity(firstFaceFeature, secondFaceFeature, 0, recognizeType.ordinal());
            }
        } else if (recognizeType == FaceSDK.RecognizeType.RECOGNIZE_LIVE && BDFaceUtils.hasModel(this.context, "recognize_model-compare.cfg")) {
            this.scoreMapInit(this.context.getAssets(), "recognize_model-compare.cfg", recognizeType.ordinal());
            return this.getFaceSimilarity(firstFaceFeature, secondFaceFeature, 0, recognizeType.ordinal());
        }
        return 0.0f;
    }

    private native int recognizeModelInit(AssetManager var1, String var2, int var3);

    private native int scoreMapInit(AssetManager var1, String var2, int var3);

    private native float getFaceSimilarity(byte[] var1, byte[] var2, int var3, int var4);

    private native int extractFeature(int[] var1, int var2, int var3, int var4, byte[] var5, int[] var6, int var7, int var8);

    private native float getConsineDistance(byte[] var1, byte[] var2);
}

