/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.license;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;

class LicenseReaderUtils {
    public static final String TAG = "License-SDK";

    LicenseReaderUtils() {
    }

    public static InputStream get_local_license_file_inputstream(Context context, String fileName) {
        if (context == null) {
            return null;
        }
        InputStream fileInputStream = LicenseReaderUtils.read_license_from_data(context, fileName);
        Log.e((String)TAG, (String)"read_license_from_data");
        if (fileInputStream == null) {
            Log.e((String)TAG, (String)"read_license_from_asset");
            fileInputStream = LicenseReaderUtils.read_license_from_asset(context, fileName);
        }
        return fileInputStream;
    }

    private static FileInputStream read_license_from_data(Context context, String fileName) {
        if (context == null) {
            return null;
        }
        FileInputStream fileInputStream = null;
        try {
            File file = context.getDir(fileName, 0);
            if (file == null || !file.exists() || !file.isFile()) {
                Log.e((String)TAG, (String)"read_license_from_data file not found");
                return null;
            }
            if (file.length() == 0L) {
                Log.e((String)TAG, (String)"read_license_from_data file is empty");
                return null;
            }
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException e1) {
            Log.e((String)TAG, (String)"read_license_from_data FileNotFoundException");
            e1.printStackTrace();
        }
        catch (Exception e2) {
            Log.e((String)TAG, (String)("read_license_from_data Exception " + e2.getMessage()));
            e2.printStackTrace();
        }
        return fileInputStream;
    }

    private static InputStream read_license_from_asset(Context context, String fileName) {
        if (context == null) {
            Log.e((String)TAG, (String)"read_license_from_asset context is null");
            return null;
        }
        InputStream inputStream = null;
        try {
            AssetManager am = context.getAssets();
            inputStream = am.open(fileName);
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"read_license_from_asset IOException");
            e.printStackTrace();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("read_license_from_asset Exception " + e.getMessage()));
            e.printStackTrace();
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean write_license_content(Context context, String fileName, ArrayList<String> licenses) {
        Log.e((String)TAG, (String)"write_license_content");
        if (licenses == null || licenses.size() == 0 || context == null) {
            return false;
        }
        boolean isSuccess = true;
        File file = context.getDir(fileName, 0);
        if (file != null && file.exists()) {
            file.delete();
        }
        if (file != null && !file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"write_license_content IOException");
                e.printStackTrace();
            }
        }
        FileOutputStream fout = null;
        try {
            fout = new FileOutputStream(file);
            for (String license : licenses) {
                fout.write(license.getBytes());
                fout.write(10);
            }
        }
        catch (FileNotFoundException e) {
            isSuccess = false;
            Log.e((String)TAG, (String)"write_license_content FileNotFoundException");
            e.printStackTrace();
        }
        catch (IOException e) {
            isSuccess = false;
            Log.e((String)TAG, (String)"write_license_content IOException");
            e.printStackTrace();
        }
        finally {
            if (fout != null) {
                try {
                    fout.close();
                }
                catch (IOException e) {
                    isSuccess = false;
                    e.printStackTrace();
                }
            }
        }
        return isSuccess;
    }

    private static ArrayList<String> read_license_content(InputStream is) throws IOException {
        String line;
        BufferedReader br = null;
        InputStreamReader reader = null;
        reader = new InputStreamReader(is);
        br = new BufferedReader(reader);
        ArrayList<String> licenses = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            licenses.add(line);
        }
        return licenses;
    }
}

