/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.utils;

import android.util.Log;

public class ImageExif {
    private static final String TAG = "CameraExif";

    public static int getOrientation(byte[] jpeg) {
        if (jpeg == null) {
            return 0;
        }
        int offset = 0;
        int length = 0;
        while (offset + 3 < jpeg.length && (jpeg[offset++] & 0xFF) == 255) {
            int marker = jpeg[offset] & 0xFF;
            if (marker == 255) continue;
            ++offset;
            if (marker == 216 || marker == 1) continue;
            if (marker == 217 || marker == 218) break;
            length = ImageExif.pack(jpeg, offset, 2, false);
            if (length < 2 || offset + length > jpeg.length) {
                Log.e((String)TAG, (String)"Invalid length");
                return 0;
            }
            if (marker == 225 && length >= 8 && ImageExif.pack(jpeg, offset + 2, 4, false) == 1165519206 && ImageExif.pack(jpeg, offset + 6, 2, false) == 0) {
                offset += 8;
                length -= 8;
                break;
            }
            offset += length;
            length = 0;
        }
        if (length > 8) {
            int tag = ImageExif.pack(jpeg, offset, 4, false);
            if (tag != 1229531648 && tag != 1296891946) {
                Log.e((String)TAG, (String)"Invalid byte order");
                return 0;
            }
            boolean littleEndian = tag == 1229531648;
            int count = ImageExif.pack(jpeg, offset + 4, 4, littleEndian) + 2;
            if (count < 10 || count > length) {
                Log.e((String)TAG, (String)"Invalid offset");
                return 0;
            }
            offset += count;
            length -= count;
            count = ImageExif.pack(jpeg, offset - 2, 2, littleEndian);
            while (count-- > 0 && length >= 12) {
                tag = ImageExif.pack(jpeg, offset, 2, littleEndian);
                if (tag == 274) {
                    int orientation = ImageExif.pack(jpeg, offset + 8, 2, littleEndian);
                    switch (orientation) {
                        case 1: {
                            return 0;
                        }
                        case 3: {
                            return 180;
                        }
                        case 6: {
                            return 90;
                        }
                        case 8: {
                            return 270;
                        }
                    }
                    Log.i((String)TAG, (String)"Unsupported orientation");
                    return 0;
                }
                offset += 12;
                length -= 12;
            }
        }
        Log.i((String)TAG, (String)"Orientation not found");
        return 0;
    }

    private static int pack(byte[] bytes, int offset, int length, boolean littleEndian) {
        int step = 1;
        if (littleEndian) {
            offset += length - 1;
            step = -1;
        }
        int value = 0;
        while (length-- > 0) {
            if (offset >= 0 && bytes != null && offset < bytes.length) {
                value = value << 8 | bytes[offset] & 0xFF;
            }
            offset += step;
        }
        return value;
    }
}

