/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.utils;

import android.content.res.AssetManager;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.idl.face.platform.utils.IoUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class FileUtils {
    public static final int S_IRWXU = 448;
    public static final int S_IRUSR = 256;
    public static final int S_IWUSR = 128;
    public static final int S_IXUSR = 64;
    public static final int S_IRWXG = 56;
    public static final int S_IRGRP = 32;
    public static final int S_IWGRP = 16;
    public static final int S_IXGRP = 8;
    public static final int S_IRWXO = 7;
    public static final int S_IROTH = 4;
    public static final int S_IWOTH = 2;
    public static final int S_IXOTH = 1;
    private static final Pattern SAFE_FILENAME_PATTERN = Pattern.compile("[\\w%+,./=_-]+");
    private static final Pattern RESERVED_CHARS_PATTERN = Pattern.compile("[\\\\/:\\*\\?\\\"<>|]");

    private FileUtils() {
    }

    public static boolean isFilenameSafe(File file) {
        return SAFE_FILENAME_PATTERN.matcher(file.getPath()).matches();
    }

    public static boolean isFilenameValid(String name) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            return false;
        }
        return !RESERVED_CHARS_PATTERN.matcher(name).find();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String src, String dest) {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(src);
            IoUtils.copyStream((InputStream)fis, new File(dest));
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(fis);
                throw throwable;
            }
            IoUtils.closeQuietly(fis);
        }
        IoUtils.closeQuietly(fis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        FileChannel in = null;
        FileChannel out = null;
        try {
            fis = new FileInputStream(src);
            fos = new FileOutputStream(dest);
            in = fis.getChannel();
            out = fos.getChannel();
            in.transferTo(0L, in.size(), out);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(fis);
                IoUtils.closeQuietly(in);
                IoUtils.closeQuietly(fos);
                IoUtils.closeQuietly(out);
                throw throwable;
            }
            IoUtils.closeQuietly(fis);
            IoUtils.closeQuietly(in);
            IoUtils.closeQuietly(fos);
            IoUtils.closeQuietly(out);
        }
        IoUtils.closeQuietly(fis);
        IoUtils.closeQuietly(in);
        IoUtils.closeQuietly(fos);
        IoUtils.closeQuietly(out);
    }

    public static void copyDirectory(File src, File dest) throws IOException {
        if (src.exists()) {
            dest.mkdirs();
            File[] files = src.listFiles();
            if (files == null) {
                return;
            }
            for (File file : files) {
                if (file.isDirectory()) {
                    FileUtils.copyDirectory(file, new File(dest, file.getName()));
                    continue;
                }
                FileUtils.copyFile(file, new File(dest, file.getName()));
            }
        }
    }

    public static void ensureDir(File file) {
        if (file.exists()) {
            if (file.isFile()) {
                file.delete();
                file.mkdirs();
            }
        } else {
            file.mkdirs();
        }
    }

    public static boolean ensureMkdir(File dir) {
        if (dir == null) {
            return false;
        }
        File tempDir = dir;
        int i = 1;
        while (tempDir.exists()) {
            tempDir = new File(dir.getParent(), dir.getName() + "(" + i + ")");
            ++i;
        }
        return tempDir.mkdir();
    }

    public static void ensureParent(File file) {
        File parentFile;
        if (null != file && null != (parentFile = file.getParentFile()) && !parentFile.exists()) {
            parentFile.mkdirs();
        }
    }

    public static void cleanDir(File dir) {
        FileUtils.deleteDir(dir, false);
    }

    public static void cleanDir(File dir, FilenameFilter filter) {
        FileUtils.deleteDir(dir, false, filter);
    }

    public static void cleanDir(File dir, FileFilter filter) {
        FileUtils.deleteDir(dir, false, filter);
    }

    public static void deleteDir(String dir) {
        FileUtils.deleteDir(new File(dir));
    }

    public static void deleteDir(File dir) {
        FileUtils.deleteDir(dir, true);
    }

    public static void deleteDir(File dir, FileFilter filter) {
        FileUtils.deleteDir(dir, true, filter);
    }

    public static void deleteDir(File dir, FilenameFilter filter) {
        FileUtils.deleteDir(dir, true, filter);
    }

    public static void deleteDir(File dir, boolean removeDir) {
        if (dir != null && dir.isDirectory()) {
            File[] files = dir.listFiles();
            if (files != null && files.length > 0) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        FileUtils.deleteDir(file, removeDir);
                        continue;
                    }
                    file.delete();
                }
            }
            if (removeDir) {
                dir.delete();
            }
        }
    }

    public static void deleteDir(File dir, boolean removeDir, FileFilter filter) {
        if (dir != null && dir.isDirectory()) {
            File[] files = dir.listFiles(filter);
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        FileUtils.deleteDir(file, removeDir, filter);
                        continue;
                    }
                    file.delete();
                }
            }
            if (removeDir) {
                dir.delete();
            }
        }
    }

    public static void deleteDir(File dir, boolean removeDir, FilenameFilter filter) {
        if (dir != null && dir.isDirectory()) {
            File[] files = dir.listFiles(filter);
            if (files != null) {
                for (File file : files) {
                    if (file.isDirectory()) {
                        FileUtils.deleteDir(file, removeDir, filter);
                        continue;
                    }
                    file.delete();
                }
            }
            if (removeDir) {
                dir.delete();
            }
        }
    }

    public static long computeFolderSize(File dir) {
        if (dir == null) {
            return 0L;
        }
        long dirSize = 0L;
        File[] files = dir.listFiles();
        if (null != files) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isFile()) {
                    dirSize += file.length();
                    continue;
                }
                if (!file.isDirectory()) continue;
                dirSize += file.length();
                dirSize += FileUtils.computeFolderSize(file);
            }
        }
        return dirSize;
    }

    public static String getFileNameWithoutExtensionByPath(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        return FileUtils.getFileNameWithoutExtension(new File(path));
    }

    public static String getFileNameWithoutExtension(String fileName) {
        String name = fileName;
        int index = fileName.lastIndexOf(46);
        if (index != -1) {
            name = fileName.substring(0, index);
        }
        return name;
    }

    public static String getFileNameWithoutExtension(File file) {
        if (null == file) {
            return null;
        }
        String fileName = file.getName();
        int index = fileName.lastIndexOf(46);
        if (index >= 0) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    public static String getExtension(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        return FileUtils.getExtension(new File(path));
    }

    public static String getExtension(File file) {
        if (null == file) {
            return null;
        }
        String fileName = file.getName();
        int index = fileName.lastIndexOf(46);
        String extension = "";
        if (index >= 0) {
            extension = fileName.substring(index + 1);
        }
        return extension;
    }

    public static boolean existsFile(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        return FileUtils.existsFile(new File(path));
    }

    public static boolean existsFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static boolean deleteFileIfExist(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return false;
        }
        File file = new File(path);
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static boolean deleteFileIfExist(File file) {
        if (file == null) {
            return false;
        }
        if (file.exists()) {
            return file.delete();
        }
        return false;
    }

    public static void writeToFile(File file, String content) {
        FileUtils.writeToFile(file, content, false, "utf-8");
    }

    public static void writeToFile(File file, String content, boolean append) {
        FileUtils.writeToFile(file, content, append, "utf-8");
    }

    public static void writeToFile(File file, String content, String encoding) {
        FileUtils.writeToFile(file, content, false, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(File file, String content, boolean append, String encoding) {
        if (file == null || TextUtils.isEmpty((CharSequence)content)) {
            return;
        }
        FileUtils.ensureParent(file);
        OutputStreamWriter writer = null;
        try {
            writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), encoding);
            writer.write(content);
            IoUtils.closeQuietly(writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IoUtils.closeQuietly(writer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void writeToFile(File file, byte[] data) {
        if (file == null || data == null) {
            return;
        }
        FileUtils.ensureParent(file);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(data);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(fos);
                throw throwable;
            }
            IoUtils.closeQuietly(fos);
        }
        IoUtils.closeQuietly(fos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFileNio(InputStream is, File target) {
        block5: {
            FileOutputStream fo = null;
            ReadableByteChannel src = null;
            FileChannel out = null;
            try {
                int len = is.available();
                src = Channels.newChannel(is);
                fo = new FileOutputStream(target);
                out = fo.getChannel();
                out.transferFrom(src, 0L, len);
                IoUtils.closeQuietly(fo);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IoUtils.closeQuietly(fo);
                IoUtils.closeQuietly(src);
                IoUtils.closeQuietly(out);
            }
            IoUtils.closeQuietly(src);
            IoUtils.closeQuietly(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFileNio(File target, byte[] data) {
        block5: {
            FileOutputStream fo = null;
            ReadableByteChannel src = null;
            FileChannel out = null;
            try {
                src = Channels.newChannel(new ByteArrayInputStream(data));
                fo = new FileOutputStream(target);
                out = fo.getChannel();
                out.transferFrom(src, 0L, data.length);
                IoUtils.closeQuietly(fo);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IoUtils.closeQuietly(fo);
                IoUtils.closeQuietly(src);
                IoUtils.closeQuietly(out);
            }
            IoUtils.closeQuietly(src);
            IoUtils.closeQuietly(out);
        }
    }

    public static String readFileText(String path) {
        if (TextUtils.isEmpty((CharSequence)path)) {
            return null;
        }
        return FileUtils.readFileText(new File(path));
    }

    public static String readFileText(File file) {
        if (FileUtils.existsFile(file)) {
            String string;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                string = IoUtils.loadContent(fis);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fis);
                    throw throwable;
                }
                IoUtils.closeQuietly(fis);
            }
            IoUtils.closeQuietly(fis);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String readFileText(String path, String charsetName) {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(path);
            string = IoUtils.loadContent(fis, charsetName);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.closeQuietly(fis);
                throw throwable;
            }
            IoUtils.closeQuietly(fis);
            return null;
        }
        IoUtils.closeQuietly(fis);
        return string;
    }

    public static byte[] readFileBytes(File file) {
        if (FileUtils.existsFile(file)) {
            byte[] byArray;
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(file);
                byArray = IoUtils.loadBytes(fis);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    IoUtils.closeQuietly(fis);
                    throw throwable;
                }
                IoUtils.closeQuietly(fis);
            }
            IoUtils.closeQuietly(fis);
            return byArray;
        }
        return null;
    }

    public static Map<String, String> readConfig(File file) {
        String[] lines;
        HashMap<String, String> map = new HashMap<String, String>();
        String text = FileUtils.readFileText(file);
        if (text == null || TextUtils.isEmpty((CharSequence)text)) {
            return map;
        }
        for (String line : lines = text.split("\n")) {
            String[] array;
            if (TextUtils.isEmpty((CharSequence)(line = line.trim())) || line.startsWith("#") || (array = line.split("=", 2)).length < 2) continue;
            map.put(array[0].trim(), array[1].trim());
        }
        return map;
    }

    public static FileOutputStream openNewFileOutput(File file) throws IOException {
        FileUtils.deleteFileIfExist(file);
        FileUtils.ensureParent(file);
        file.createNewFile();
        return new FileOutputStream(file);
    }

    public static File getUserDir() {
        String path = System.getProperty("user.dir");
        return new File(path);
    }

    public static File getUserHome() {
        String path = System.getProperty("user.home");
        return new File(path);
    }

    public static boolean isSdCardAvailable() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static File getSDRootFile() {
        if (FileUtils.isSdCardAvailable()) {
            return Environment.getExternalStorageDirectory();
        }
        return null;
    }

    public static File createCollectDirectory() {
        File sdRootFile = FileUtils.getSDRootFile();
        File file = null;
        if (sdRootFile != null && sdRootFile.exists() && !(file = new File(sdRootFile, "CollectBest")).exists()) {
            file.mkdirs();
        }
        return file;
    }

    public static String readAssetFileUtf8String(AssetManager assetManager, String filename) throws IOException {
        byte[] bytes = FileUtils.readAssetFileContent(assetManager, filename);
        return new String(bytes, Charset.forName("UTF-8"));
    }

    public static byte[] readAssetFileContent(AssetManager assetManager, String filename) throws IOException {
        Log.i((String)"FileUtil", (String)(" try to read asset file :" + filename));
        InputStream is = assetManager.open(filename);
        int size = is.available();
        byte[] buffer = new byte[size];
        int realSize = is.read(buffer);
        if (realSize != size) {
            throw new IOException("realSize is not equal to size: " + realSize + " : " + size);
        }
        is.close();
        return buffer;
    }
}

