/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.media.ExifInterface;
import com.baidu.idl.face.platform.utils.Base64Utils;
import com.baidu.idl.face.platform.utils.DensityUtils;
import com.baidu.idl.main.facesdk.model.BDFaceImageInstance;
import com.baidu.idl.main.facesdk.model.BDFaceSDKCommon;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public final class BitmapUtils {
    private static final String TAG = "ImageUtils";
    private static final int QUALITY = 100;
    public static final int ROTATE0 = 0;
    public static final int ROTATE90 = 90;
    public static final int ROTATE180 = 180;
    public static final int ROTATE270 = 270;
    public static final int ROTATE360 = 360;
    public static final int PIC_COMPRESS_SIZE = 4;
    public static final int IMAGEBOUND = 128;
    public static final int MAXLENTH = 1024;

    private BitmapUtils() {
    }

    public static Bitmap createBitmap(Context context, byte[] data, float orientation) {
        Bitmap bitmap = null;
        Bitmap transformed = null;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        try {
            int width = DensityUtils.getDisplayWidth(context);
            int hight = DensityUtils.getDisplayHeight(context);
            int min = Math.min(width, hight);
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            opts.inSampleSize = BitmapUtils.computeSampleSize(opts, min, 0x100000);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            transformed = BitmapUtils.rotateBitmap(orientation, bitmap);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (bitmap != null && !bitmap.isRecycled()) {
                bitmap.recycle();
                bitmap = null;
            }
            if (transformed != null && !transformed.isRecycled()) {
                transformed.recycle();
                transformed = null;
            }
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            opts.inSampleSize = BitmapUtils.computeSampleSize(opts, -1, opts.outWidth * opts.outHeight / 4);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])data, (int)0, (int)data.length, (BitmapFactory.Options)opts);
            transformed = BitmapUtils.rotateBitmap(orientation, bitmap);
        }
        if (transformed != bitmap && bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return transformed;
    }

    public static Bitmap rotateBitmap(float orientation, Bitmap bitmap) {
        Bitmap transformed;
        Matrix m = new Matrix();
        if (orientation == 0.0f) {
            transformed = bitmap;
        } else {
            m.setRotate(orientation);
            transformed = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)m, (boolean)true);
        }
        return transformed;
    }

    public static int computeSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int roundedSize;
        int initialSize = BitmapUtils.computeInitialSampleSize(options, minSideLength, maxNumOfPixels);
        if (initialSize <= 8) {
            for (roundedSize = 1; roundedSize < initialSize; roundedSize <<= 1) {
            }
        } else {
            roundedSize = (initialSize + 7) / 8 * 8;
        }
        return roundedSize;
    }

    public static int computeInitialSampleSize(BitmapFactory.Options options, int minSideLength, int maxNumOfPixels) {
        int upperBound;
        double w = options.outWidth;
        double h = options.outHeight;
        int lowerBound = maxNumOfPixels == -1 ? 1 : (int)Math.ceil(Math.sqrt(w * h / (double)maxNumOfPixels));
        int n = upperBound = minSideLength == -1 ? 128 : (int)Math.min(Math.floor(w / (double)minSideLength), Math.floor(h / (double)minSideLength));
        if (upperBound < lowerBound) {
            return lowerBound;
        }
        if (maxNumOfPixels == -1 && minSideLength == -1) {
            return 1;
        }
        if (minSideLength == -1) {
            return lowerBound;
        }
        return upperBound;
    }

    public static int decodeImageDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
                default: {
                    degree = 0;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            degree = 0;
        }
        return degree;
    }

    public static Bitmap scale(Bitmap bitmap, float scale) {
        Matrix matrix = new Matrix();
        matrix.postScale(scale, scale);
        Bitmap newBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
        if (bitmap != null) {
            bitmap.recycle();
        }
        return newBitmap;
    }

    public static Bitmap scale(Bitmap bitmap, int w, int h) {
        if (bitmap == null) {
            return null;
        }
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Matrix matrix = new Matrix();
        float scaleWidth = (float)w / (float)width;
        float scaleHeight = (float)h / (float)height;
        matrix.postScale(scaleWidth, scaleHeight);
        return Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)width, (int)height, (Matrix)matrix, (boolean)true);
    }

    public static Bitmap calculateInSampleSize(Bitmap resBitmap, int desWidth, int desHeight) {
        int resWidth = resBitmap.getWidth();
        int resHeight = resBitmap.getHeight();
        if (resHeight > desHeight || resWidth > desWidth) {
            float heightRatio = (float)desHeight / (float)resHeight;
            float widthRatio = (float)desWidth / (float)resWidth;
            float scale = heightRatio < widthRatio ? heightRatio : widthRatio;
            return BitmapUtils.scale(resBitmap, scale);
        }
        return resBitmap;
    }

    public static Bitmap createBitmap(Context context, String filename, int orientatoin) {
        Bitmap bitmap = null;
        Bitmap transformed = null;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        try {
            int width = DensityUtils.getDisplayWidth(context);
            int hight = DensityUtils.getDisplayHeight(context);
            int min = Math.min(width, hight);
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)opts);
            opts.inSampleSize = BitmapUtils.computeSampleSize(opts, min, 0x100000);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)opts);
            transformed = BitmapUtils.rotateBitmap(orientatoin, bitmap);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (bitmap != null) {
                bitmap.recycle();
            }
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)opts);
            opts.inSampleSize = BitmapUtils.computeSampleSize(opts, -1, opts.outWidth * opts.outHeight / 4);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeFile((String)filename, (BitmapFactory.Options)opts);
            transformed = BitmapUtils.rotateBitmap(orientatoin, bitmap);
        }
        if (transformed != bitmap && bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return transformed;
    }

    public static Bitmap createBitmap(Context context, byte[] imageByte, int orientatoin) {
        Bitmap bitmap = null;
        Bitmap transformed = null;
        BitmapFactory.Options opts = new BitmapFactory.Options();
        try {
            int width = DensityUtils.getDisplayWidth(context);
            int hight = DensityUtils.getDisplayHeight(context);
            int min = Math.min(width, hight);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])imageByte, (int)0, (int)imageByte.length);
            transformed = BitmapUtils.rotateBitmap(orientatoin, bitmap);
        }
        catch (OutOfMemoryError e) {
            e.printStackTrace();
            if (bitmap != null) {
                bitmap.recycle();
            }
            opts.inJustDecodeBounds = true;
            BitmapFactory.decodeByteArray((byte[])imageByte, (int)0, (int)imageByte.length, (BitmapFactory.Options)opts);
            opts.inSampleSize = BitmapUtils.computeSampleSize(opts, -1, opts.outWidth * opts.outHeight / 4);
            opts.inJustDecodeBounds = false;
            bitmap = BitmapFactory.decodeByteArray((byte[])imageByte, (int)0, (int)imageByte.length, (BitmapFactory.Options)opts);
            transformed = BitmapUtils.rotateBitmap(orientatoin, bitmap);
        }
        if (transformed != bitmap && bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return transformed;
    }

    public static Bitmap createBitmap(Context context, int pw, int ph, int[] argbByte) {
        Bitmap transformed;
        Bitmap bitmap;
        block3: {
            bitmap = null;
            transformed = null;
            BitmapFactory.Options opts = new BitmapFactory.Options();
            try {
                int width = DensityUtils.getDisplayWidth(context);
                int hight = DensityUtils.getDisplayHeight(context);
                int min = Math.min(width, hight);
                opts.inJustDecodeBounds = false;
                bitmap = Bitmap.createBitmap((int[])argbByte, (int)pw, (int)ph, (Bitmap.Config)Bitmap.Config.RGB_565);
            }
            catch (OutOfMemoryError e) {
                e.printStackTrace();
                if (bitmap == null) break block3;
                bitmap.recycle();
            }
        }
        if (transformed != bitmap && bitmap != null) {
            bitmap.recycle();
            bitmap = null;
        }
        return transformed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] bitmapCompress(Bitmap bitmap, int quality) {
        ByteArrayOutputStream out = null;
        try {
            byte[] data;
            out = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
            byte[] byArray = data = out.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String bitmapToJpegBase64(Bitmap bitmap, int quality, float maxSize) {
        try {
            float scale = maxSize / (float)Math.max(bitmap.getWidth(), bitmap.getHeight());
            if (scale < 1.0f) {
                bitmap = BitmapUtils.scale(bitmap, scale);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)out);
            byte[] data = out.toByteArray();
            out.close();
            return Base64Utils.encodeToString(data, 2);
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveBitmap(File file, Bitmap bitmap) {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)out);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static Bitmap yuv2Bitmap(byte[] data, int width, int height) {
        int frameSize = width * height;
        int[] rgba = new int[frameSize];
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int y = 0xFF & data[i * width + j];
                int u = 0xFF & data[frameSize + (i >> 1) * width + (j & 0xFFFFFFFE) + 0];
                int v = 0xFF & data[frameSize + (i >> 1) * width + (j & 0xFFFFFFFE) + 1];
                y = y < 16 ? 16 : y;
                int r = Math.round(1.164f * (float)(y - 16) + 1.596f * (float)(v - 128));
                int g = Math.round(1.164f * (float)(y - 16) - 0.813f * (float)(v - 128) - 0.391f * (float)(u - 128));
                int b = Math.round(1.164f * (float)(y - 16) + 2.018f * (float)(u - 128));
                int n = r < 0 ? 0 : (r = r > 255 ? 255 : r);
                int n2 = g < 0 ? 0 : (g = g > 255 ? 255 : g);
                b = b < 0 ? 0 : (b > 255 ? 255 : b);
                rgba[i * width + j] = -16777216 + (b << 16) + (g << 8) + r;
            }
        }
        Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bmp.setPixels(rgba, 0, width, 0, 0, width, height);
        return bmp;
    }

    public static Bitmap Depth2Bitmap(byte[] depthBytes, int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        int[] argbData = new int[width * height];
        for (int i = 0; i < width * height; ++i) {
            argbData[i] = (depthBytes[i * 2] + depthBytes[i * 2 + 1] * 256) / 10 & 0xFF | ((depthBytes[i * 2] + depthBytes[i * 2 + 1] * 256) / 10 & 0xFF) << 8 | ((depthBytes[i * 2] + depthBytes[i * 2 + 1] * 256) / 10 & 0xFF) << 16 | 0xFF000000;
        }
        bitmap.setPixels(argbData, 0, width, 0, 0, width, height);
        return bitmap;
    }

    public static Bitmap BGR2Bitmap(byte[] bytes, int width, int height) {
        Bitmap stitchBmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        byte[] rgba = new byte[width * height * 4];
        for (int i = 0; i < width * height; ++i) {
            byte b3;
            byte b1 = bytes[i * 3 + 0];
            byte b2 = bytes[i * 3 + 1];
            rgba[i * 4 + 0] = b3 = bytes[i * 3 + 2];
            rgba[i * 4 + 1] = b2;
            rgba[i * 4 + 2] = b1;
            rgba[i * 4 + 3] = -1;
        }
        stitchBmp.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(rgba));
        return stitchBmp;
    }

    public static Bitmap getInstaceBmp(BDFaceImageInstance newInstance) {
        Bitmap transBmp = null;
        if (newInstance.imageType == BDFaceSDKCommon.BDFaceImageType.BDFACE_IMAGE_TYPE_RGBA) {
            transBmp = Bitmap.createBitmap((int)newInstance.width, (int)newInstance.height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            transBmp.copyPixelsFromBuffer((Buffer)ByteBuffer.wrap(newInstance.data));
        } else if (newInstance.imageType == BDFaceSDKCommon.BDFaceImageType.BDFACE_IMAGE_TYPE_BGR) {
            transBmp = BitmapUtils.BGR2Bitmap(newInstance.data, newInstance.width, newInstance.height);
        } else if (newInstance.imageType == BDFaceSDKCommon.BDFaceImageType.BDFACE_IMAGE_TYPE_YUV_NV21) {
            transBmp = BitmapUtils.yuv2Bitmap(newInstance.data, newInstance.width, newInstance.height);
        } else if (newInstance.imageType == BDFaceSDKCommon.BDFaceImageType.BDFACE_IMAGE_TYPE_GRAY) {
            transBmp = BitmapUtils.Depth2Bitmap(newInstance.data, newInstance.width, newInstance.height);
        }
        return transBmp;
    }
}

