/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.common;

import android.text.TextUtils;
import com.baidu.idl.face.platform.FaceStatusNewEnum;
import com.baidu.idl.face.platform.network.LogRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class LogHelper {
    private static final String TAG = LogHelper.class.getSimpleName();
    private static HashMap<String, Object> logMap = new HashMap();
    private static ArrayList<Integer> logLivenessLiveness = new ArrayList();
    private static HashMap<String, Integer> logTipsMap = new HashMap();

    public static void addLogWithKey(String key, Object value) {
        if (logMap != null && !logMap.containsKey(key)) {
            logMap.put(key, value);
        }
    }

    public static void addLog(String key, Object value) {
        if (logMap != null) {
            logMap.put(key, value);
        }
    }

    public static void addLivenessLog(int livenessIndex) {
        if (logLivenessLiveness != null && !logLivenessLiveness.contains(livenessIndex)) {
            logLivenessLiveness.add(livenessIndex);
        }
    }

    public static void addTipsLogWithKey(String status) {
        if (logTipsMap != null && !logTipsMap.containsKey(status)) {
            logTipsMap.put(status, 1);
        } else if (logTipsMap != null && logTipsMap.containsKey(status)) {
            int count = logTipsMap.get(status) + 1;
            logTipsMap.put(status, count);
        }
    }

    private static String getLog() {
        StringBuilder log = new StringBuilder();
        try {
            int index = 0;
            log.append("{");
            for (Map.Entry<String, Object> entry : logMap.entrySet()) {
                if (index == logMap.size() - 1) {
                    if (entry.getValue() instanceof String) {
                        log.append(entry.getKey() + ":'" + entry.getValue() + "'");
                    } else {
                        log.append(entry.getKey() + ":" + entry.getValue());
                    }
                } else {
                    if (entry.getValue() instanceof String) {
                        log.append(entry.getKey() + ":'" + entry.getValue() + "'");
                    } else {
                        log.append(entry.getKey() + ":" + entry.getValue());
                    }
                    log.append(",");
                }
                ++index;
            }
            if (logLivenessLiveness != null && logLivenessLiveness.size() > 0) {
                log.append(",lv:[");
                for (int i = 0; i < logLivenessLiveness.size(); ++i) {
                    if (i == logLivenessLiveness.size() - 1) {
                        log.append(logLivenessLiveness.get(i));
                        continue;
                    }
                    log.append(logLivenessLiveness.get(i) + ",");
                }
                log.append("]");
            }
            if (logTipsMap != null && logTipsMap.size() > 0) {
                log.append(",msg:{");
                log.append(LogHelper.getTipsMessage());
                log.append("}");
            }
            log.append("}");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logMap = new HashMap();
        logLivenessLiveness = new ArrayList();
        logTipsMap = new HashMap();
        return log.toString();
    }

    private static String getTipsMessage() {
        StringBuilder log = new StringBuilder();
        int index = 0;
        String key = "";
        for (Map.Entry<String, Integer> entry : logTipsMap.entrySet()) {
            key = LogHelper.getTipsKey(entry.getKey());
            if (!TextUtils.isEmpty((CharSequence)key)) {
                log.append(key + ":" + entry.getValue());
                log.append(",");
            }
            ++index;
        }
        if (log.length() > 0) {
            log.deleteCharAt(log.length() - 1);
        }
        return log.toString();
    }

    private static String getTipsKey(String key) {
        String tipsKey = "";
        if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeOcclusionLeftEye.name())) {
            tipsKey = "leftEyeOccusion";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeOcclusionRightEye.name())) {
            tipsKey = "rightEyeOccusion";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeOcclusionNose.name())) {
            tipsKey = "noseOccusion";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeOcclusionMouth.name())) {
            tipsKey = "mouthOccusion";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeOcclusionLeftContour.name())) {
            tipsKey = "leftFaceOccusion";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeOcclusionRightContour.name())) {
            tipsKey = "rightFaceOccusion";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeOcclusionChinContour.name())) {
            tipsKey = "chinOccusion";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodePoorIllumination.name())) {
            tipsKey = "lightUp";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeImageBlured.name())) {
            tipsKey = "stayStill";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeTooFar.name())) {
            tipsKey = "moveClose";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeTooClose.name())) {
            tipsKey = "moveFurther";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodePitchOutofDownRange.name())) {
            tipsKey = "headUp";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodePitchOutofUpRange.name())) {
            tipsKey = "headDown";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeYawOutofRightRange.name())) {
            tipsKey = "turnLeft";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeYawOutofLeftRange.name())) {
            tipsKey = "turnRight";
        } else if (TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeNoFaceDetected.name()) || TextUtils.equals((CharSequence)key, (CharSequence)FaceStatusNewEnum.DetectRemindCodeBeyondPreviewFrame.name())) {
            tipsKey = "moveFace";
        }
        return tipsKey;
    }

    public static void sendLog() {
        String message = LogHelper.getLog();
        LogRequest.sendLogMessage(message);
    }

    public static void clear() {
        logMap = new HashMap();
        logLivenessLiveness = new ArrayList();
        logTipsMap = new HashMap();
    }
}

