/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.utils;

import android.text.TextUtils;
import com.baidu.idl.face.platform.utils.FileUtils;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.net.ServerSocket;
import java.util.zip.ZipFile;

public class IoUtils {
    private static final int EOF = -1;
    private static final int BUFFER_SIZE = 1024;

    public static void copyStream(InputStream in, OutputStream out) throws IOException {
        byte[] buffer = new byte[1024];
        int len = 0;
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
        }
    }

    public static void copyStream(InputStream in, File outFile) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = FileUtils.openNewFileOutput(outFile);
            IoUtils.copyStream(in, fos);
        }
        finally {
            IoUtils.closeQuietly(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStream(InputStream in, File outFile, long total, ProgressListener l) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = FileUtils.openNewFileOutput(outFile);
            IoUtils.copyStream(in, fos, total, l);
        }
        finally {
            IoUtils.closeQuietly(fos);
        }
    }

    public static void copyStream(InputStream in, OutputStream out, long total, ProgressListener l) throws IOException {
        byte[] buffer = new byte[1024];
        long current = 0L;
        int len = 0;
        while ((len = in.read(buffer)) != -1) {
            out.write(buffer, 0, len);
            current += (long)len;
            if (l == null) continue;
            l.progress(current, total);
        }
    }

    public static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeQuietly(ServerSocket socket) {
        if (socket != null) {
            try {
                socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void closeQuietly(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static String loadContent(InputStream stream) throws IOException {
        return IoUtils.loadContent(stream, null);
    }

    public static String loadContent(InputStream stream, String charsetName) throws IOException {
        if (stream == null) {
            throw new IllegalArgumentException("stream may not be null.");
        }
        String encoding = charsetName;
        if (TextUtils.isEmpty((CharSequence)encoding)) {
            encoding = System.getProperty("file.encoding", "utf-8");
        }
        InputStreamReader reader = new InputStreamReader(stream, encoding);
        StringWriter writer = new StringWriter();
        char[] buffer = new char[4096];
        int len = reader.read(buffer);
        while (len > 0) {
            writer.write(buffer, 0, len);
            len = reader.read(buffer);
        }
        return writer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] loadBytes(InputStream in) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] data = null;
        try {
            IoUtils.copyStream(in, out);
            data = out.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IoUtils.closeQuietly(out);
        }
        return data;
    }

    public static interface ProgressListener {
        public void progress(long var1, long var3);
    }
}

