/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.vis.unified.license;

import android.content.Context;
import android.util.Log;
import com.baidu.vis.unified.license.HttpStatus;
import com.baidu.vis.unified.license.HttpUtils;
import com.baidu.vis.unified.license.LicenseReaderUtils;
import com.baidu.vis.unified.license.ReadStatusCode;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.json.JSONObject;

class LicenseNewReader {
    public static final String TAG = "License-SDK";

    LicenseNewReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int readFile(Context context, String filePath, ArrayList<String> fileContent) {
        if (context == null || filePath == null || fileContent == null) {
            return -1;
        }
        ArrayList<String> license = new ArrayList<String>();
        InputStream fis = null;
        ReadStatusCode readStatusCode = new ReadStatusCode();
        readStatusCode.is_from_asset = false;
        try {
            String line;
            BufferedReader br = null;
            InputStreamReader reader = null;
            fis = LicenseReaderUtils.get_local_license_file_inputstream(context, filePath, readStatusCode);
            if (fis == null) {
                Log.e((String)TAG, (String)"open license file error.");
                int n = -1;
                return n;
            }
            reader = new InputStreamReader(fis);
            br = new BufferedReader(reader);
            while ((line = br.readLine()) != null) {
                license.add(line);
            }
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)("license file FileNotFoundException " + filePath));
            int br = -1;
            return br;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)("license file IOException " + filePath));
            int br = -2;
            return br;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("license file Exception " + filePath + " " + e.getMessage()));
            int br = -2;
            return br;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (fileContent != null && license != null && license.size() > 0) {
            if (readStatusCode.is_from_asset) {
                LicenseReaderUtils.write_license_content(context, filePath, license);
            }
            for (String item : license) {
                fileContent.add(item);
                Log.e((String)TAG, (String)("license file info =" + item));
            }
        }
        return license.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int writeFile(Context context, String licensePath, String license) {
        if (context == null || licensePath == null || license == null) {
            return -1;
        }
        File file = null;
        if (licensePath.startsWith("/")) {
            file = new File(licensePath);
        } else {
            file = context.getDir(licensePath, 0);
            Log.e((String)TAG, (String)("put_local_license =" + file.getAbsolutePath()));
        }
        if (file != null) {
            file.delete();
        }
        if (file != null && !file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"IOException");
                return -2;
            }
        }
        int ret = 1;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            fos.write(license.getBytes());
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"FileNotFoundException");
            e.printStackTrace();
            ret = -1;
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"IOException");
            e.printStackTrace();
            ret = -2;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Exception");
            ret = -2;
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    ret = -2;
                }
            }
        }
        return ret;
    }

    public static HttpStatus httpPostRequest(Context context, String url, String postData) {
        String paramStr = "";
        HttpStatus httpStatus = null;
        try {
            if (!"".equals(postData)) {
                JSONObject jsonObject = new JSONObject(postData);
                String alStr = jsonObject.getString("sdk_v");
                String queryStr = jsonObject.getString("query");
                paramStr = String.format("sdk_v=%s&query=%s", alStr, queryStr);
            }
            Log.e((String)TAG, (String)("request get_remote_license =" + url));
            httpStatus = HttpUtils.requestPost(url, paramStr, "application/x-www-form-urlencoded", TAG);
            if (httpStatus != null) {
                Log.e((String)"jni", (String)("java result = " + httpStatus.responseStr));
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("Exception " + e.getMessage()));
            e.printStackTrace();
        }
        return httpStatus;
    }
}

