/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.vis.unified.license;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.vis.unified.license.AndroidLicenser;
import com.baidu.vis.unified.license.BDLicenseLocalInfo;
import com.baidu.vis.unified.license.HttpStatus;
import com.baidu.vis.unified.license.HttpUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class BDLicenseActivator {
    public static final String TAG = "BDLicenseActivator";

    public static int initLicenseOnLine(Context context, String licenseID, String filename, int algorithmID) {
        AndroidLicenser licenser;
        AndroidLicenser.ErrorCode errorCode;
        if (context == null) {
            Log.e((String)TAG, (String)"initLicenseOnLine parameter error context == null");
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)licenseID)) {
            Log.e((String)TAG, (String)"initLicenseOnLine parameter error licenseID is empty");
            return -1;
        }
        if (TextUtils.isEmpty((CharSequence)filename)) {
            filename = licenseID;
        }
        if ((errorCode = (licenser = AndroidLicenser.getInstance()).authFromFile(context, licenseID, filename, true, algorithmID)) == AndroidLicenser.ErrorCode.SUCCESS) {
            return 0;
        }
        String device = AndroidLicenser.getDeviceId(context.getApplicationContext());
        String url = "https://ai.baidu.com/activation/key/activate";
        String paramStr = null;
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("deviceId", (Object)device);
            jsonObject.put("key", (Object)licenseID);
            jsonObject.put("platformType", 2);
            jsonObject.put("version", 1);
            paramStr = jsonObject.toString();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        HttpStatus httpStatus = HttpUtils.requestPost(url, paramStr, "application/json", TAG);
        if (httpStatus == null) {
            Log.e((String)TAG, (String)"initLicenseOnLine.HttpUtils.requestPost error httpStatus == null ");
            return -2;
        }
        String response = httpStatus.responseStr;
        try {
            JSONObject json = new JSONObject(response);
            int jsonErrorCode = json.optInt("error_code");
            if (jsonErrorCode != 0) {
                String errorMsg = json.optString("error_msg");
                Log.e((String)TAG, (String)("initLicenseOnLine.requestPost.response.error_code -> " + errorMsg));
                return -3;
            }
            JSONObject result = json.optJSONObject("result");
            if (result == null) {
                Log.e((String)TAG, (String)"initLicenseOnLine.requestPost.response error result == null");
                return -3;
            }
            String license = result.optString("license");
            if (TextUtils.isEmpty((CharSequence)license)) {
                Log.e((String)TAG, (String)"initLicenseOnLine.requestPost.response error license is empty");
                return -3;
            }
            String[] licenses = license.split(",");
            if (licenses == null || licenses.length != 2) {
                Log.e((String)TAG, (String)"initLicenseOnLine.requestPost.response error licenses == null || licenses.length != 2");
                return -3;
            }
            errorCode = licenser.authFromMemory(context, licenseID, licenses, filename, algorithmID);
            if (errorCode != AndroidLicenser.ErrorCode.SUCCESS) {
                BDLicenseLocalInfo info = licenser.authGetLocalInfo(context, algorithmID);
                Log.e((String)TAG, (String)("BDLicenseLocalInfo -> " + info.toString()));
                String errMsg = licenser.getErrorMsg(algorithmID);
                Log.e((String)TAG, (String)("errMsg ->" + errMsg));
                return -4;
            }
            return 0;
        }
        catch (JSONException e) {
            e.printStackTrace();
            Log.i((String)TAG, (String)"httpStatus.responseStr error");
            return -5;
        }
    }
}

