/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.vis.unified.license;

import android.content.Context;
import android.util.Log;
import android.util.Pair;
import com.baidu.vis.unified.license.BDLicenseAuthInfo;
import com.baidu.vis.unified.license.BDLicenseLocalInfo;
import java.lang.reflect.Method;
import java.util.concurrent.locks.ReentrantLock;

public class AndroidLicenser {
    private static AndroidLicenser mInstance = null;
    private static String deviceID = "";
    private static String mIdFlag = "1";
    private static boolean mOnline = false;
    private static boolean mAgree = false;
    private ReentrantLock lock = new ReentrantLock();
    private static ReentrantLock lock_instance = new ReentrantLock();

    public static synchronized AndroidLicenser getInstance() {
        lock_instance.lock();
        if (null == mInstance) {
            mInstance = new AndroidLicenser();
            try {
                Log.e((String)"License-SDK", (String)"bd_unifylicense load start");
                System.loadLibrary("bd_unifylicense");
                Log.e((String)"License-SDK", (String)"bd_unifylicense load end");
            }
            catch (Exception e) {
                Log.e((String)"License-SDK", (String)"bd_unifylicense load Exception");
                e.printStackTrace();
            }
        }
        lock_instance.unlock();
        return mInstance;
    }

    private AndroidLicenser() {
    }

    public static void setIdFlag(String idFlag) {
        mIdFlag = idFlag;
    }

    public static void setOnline(boolean online) {
        mOnline = online;
    }

    public static void setAgree(boolean agree) {
        mAgree = agree;
    }

    public static synchronized String getDeviceId(Context context) {
        if ("".equals(deviceID)) {
            try {
                ClassLoader loader = context.getClassLoader();
                Class<?> classLH = loader.loadClass("com.baidu.liantian.ac.LH");
                Method initMethod = classLH.getDeclaredMethod("init", Context.class, Boolean.TYPE);
                initMethod.invoke(classLH, context, mOnline);
                Log.i((String)"License-SDK", (String)"Load liantian ac succeed");
                Method agreeMethod = classLH.getDeclaredMethod("setAgreePolicy", Context.class, Boolean.TYPE);
                agreeMethod.invoke(classLH, context, mAgree);
                Method getIdMethod = classLH.getDeclaredMethod("getId", Context.class, String.class);
                Pair deviceId = (Pair)getIdMethod.invoke(classLH, context, mIdFlag);
                if (deviceId != null && deviceId.second != null) {
                    deviceID = ((String)deviceId.second).toUpperCase();
                }
            }
            catch (Exception var2) {
                var2.printStackTrace();
                Log.i((String)"License-SDK", (String)"Load liantian ac failed");
            }
        }
        return deviceID;
    }

    public ErrorCode authFromFolder(Context context, String licenseFolder, boolean isRemote, int algorithmId) {
        int errCode;
        this.lock.lock();
        try {
            errCode = this.nativeFaceAuthFromFolder(context, licenseFolder, isRemote, algorithmId);
        }
        catch (Exception e) {
            errCode = ErrorCode.OTHER_ERROR.ordinal();
            e.printStackTrace();
        }
        this.lock.unlock();
        return ErrorCode.values()[errCode];
    }

    public ErrorCode authFromFile(Context context, String licenseKey, String licenseName, boolean isRemote, int algorithmId) {
        int errCode;
        this.lock.lock();
        try {
            errCode = this.nativeFaceAuthFromFile(context, licenseKey, licenseName, isRemote, algorithmId);
        }
        catch (Exception e) {
            errCode = ErrorCode.OTHER_ERROR.ordinal();
            e.printStackTrace();
        }
        this.lock.unlock();
        return ErrorCode.values()[errCode];
    }

    public ErrorCode authFromMemory(Context context, String licenseKey, String[] licenseContent, String licenseName, int algorithmId) {
        int errCode;
        this.lock.lock();
        try {
            errCode = this.nativeFaceAuthFromMemory(context, licenseKey, licenseContent, licenseName, algorithmId);
        }
        catch (Exception e) {
            errCode = ErrorCode.OTHER_ERROR.ordinal();
            e.printStackTrace();
        }
        this.lock.unlock();
        return ErrorCode.values()[errCode];
    }

    public BDLicenseLocalInfo authGetLocalInfo(Context context, int algorithmId) {
        BDLicenseLocalInfo info;
        this.lock.lock();
        try {
            info = this.nativeFaceAuthGetLocalInfo(context, algorithmId);
        }
        catch (Exception e) {
            info = new BDLicenseLocalInfo("", -1, "", "", "", "", "");
            e.printStackTrace();
        }
        this.lock.unlock();
        return info;
    }

    public BDLicenseAuthInfo authGetAuthInfo(Context context, int algorithmId) {
        BDLicenseAuthInfo info;
        this.lock.lock();
        try {
            info = this.nativeFaceAuthGetAuthInfo(context, algorithmId);
        }
        catch (Exception e) {
            info = new BDLicenseAuthInfo("", -1, "", "", "", 0L, "");
            e.printStackTrace();
        }
        this.lock.unlock();
        return info;
    }

    public ErrorCode getAuthStatus(int algorithmId) {
        int errCode;
        try {
            errCode = this.nativeFaceGetAuthStatus(algorithmId);
        }
        catch (Exception e) {
            errCode = ErrorCode.OTHER_ERROR.ordinal();
            e.printStackTrace();
        }
        return ErrorCode.values()[errCode];
    }

    public ErrorCode authIsFuncAvailable(String funcName, int algorithmId) {
        int errCode;
        try {
            errCode = this.nativeFaceIsFunctionAvailable(funcName, algorithmId);
        }
        catch (Exception e) {
            errCode = ErrorCode.OTHER_ERROR.ordinal();
            e.printStackTrace();
        }
        return ErrorCode.values()[errCode];
    }

    public String getErrorMsg(int algorithmId) {
        String errMsg;
        try {
            errMsg = this.nativeFaceGetErrorMsg(algorithmId);
        }
        catch (Exception e) {
            errMsg = "";
            e.printStackTrace();
        }
        return errMsg;
    }

    public void authDisableDeviceId(int algorithmId) {
        try {
            this.nativeDisableDeviceId(algorithmId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void authReleaseAuth(int algorithmId) {
        try {
            this.nativeReleaseAuth(algorithmId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private native int nativeFaceAuthFromFolder(Context var1, String var2, boolean var3, int var4);

    private native int nativeFaceAuthFromFile(Context var1, String var2, String var3, boolean var4, int var5);

    private native int nativeFaceAuthFromMemory(Context var1, String var2, String[] var3, String var4, int var5);

    private native BDLicenseLocalInfo nativeFaceAuthGetLocalInfo(Context var1, int var2);

    private native BDLicenseAuthInfo nativeFaceAuthGetAuthInfo(Context var1, int var2);

    private native int nativeFaceGetAuthStatus(int var1);

    private native int nativeFaceIsFunctionAvailable(String var1, int var2);

    private native String nativeFaceGetErrorMsg(int var1);

    private native void nativeDisableDeviceId(int var1);

    private native void nativeReleaseAuth(int var1);

    public static enum ErrorCode {
        SUCCESS,
        LICENSE_NOT_INIT_ERROR,
        LICENSE_DECRYPT_ERROR,
        LICENSE_INFO_FORMAT_ERROR,
        LICENSE_KEY_CHECK_ERROR,
        LICENSE_ALGORITHM_CHECK_ERROR,
        LICENSE_MD5_CHECK_ERROR,
        LICENSE_DEVICE_ID_CHECK_ERROR,
        LICENSE_PACKAGE_NAME_CHECK_ERROR,
        LICENSE_EXPIRED_TIME_CHECK_ERROR,
        LICENSE_FUNCTION_CHECK_ERROR,
        LICENSE_TIME_EXPIRED,
        LICENSE_LOCAL_FILE_ERROR,
        LICENSE_REMOTE_DATA_ERROR,
        LICENSE_LOCAL_TIME_ERROR,
        LICENSE_PARAM_ERROR,
        LICENSE_KEY_FILE_ERROR,
        OTHER_ERROR;

    }
}

