/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk.utils;

import android.util.Log;
import com.baidu.idl.main.facesdk.utils.IOUtil;
import com.baidu.idl.main.facesdk.utils.SafeZipEntry;
import com.baidu.idl.main.facesdk.utils.SafeZipInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtils {
    public static boolean isSuccess;

    private ZipUtils() {
    }

    public static File zip(String filePath) {
        File target = null;
        File source = new File(filePath);
        if (source.exists()) {
            String zipName = source.getName() + ".zip";
            target = new File(source.getParent(), zipName);
            if (target.exists()) {
                target.delete();
            }
            FileOutputStream fos = null;
            ZipOutputStream zos = null;
            try {
                fos = new FileOutputStream(target);
                zos = new ZipOutputStream(new BufferedOutputStream(fos));
                ZipUtils.addEntry("/", source, zos);
            }
            catch (IOException e) {
                try {
                    throw new RuntimeException(e);
                }
                catch (Throwable throwable) {
                    IOUtil.closeQuietly(zos, fos);
                    throw throwable;
                }
            }
            IOUtil.closeQuietly(zos, fos);
        }
        return target;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addEntry(String base, File source, ZipOutputStream zos) throws IOException {
        String entry = base + source.getName();
        if (source.isDirectory()) {
            File[] fileArray = source.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZipUtils.addEntry(entry + "/", file, zos);
                ++n2;
            }
            return;
        }
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            byte[] buffer = new byte[10240];
            fis = new FileInputStream(source);
            bis = new BufferedInputStream(fis, buffer.length);
            int read = 0;
            zos.putNextEntry(new ZipEntry(entry));
            while ((read = bis.read(buffer, 0, buffer.length)) != -1) {
                zos.write(buffer, 0, read);
            }
            zos.closeEntry();
        }
        catch (Throwable throwable) {
            IOUtil.closeQuietly(bis, fis);
            throw throwable;
        }
        IOUtil.closeQuietly(bis, fis);
    }

    public static boolean unzip(String filePath) {
        boolean flag = false;
        File srcFile = new File(filePath);
        SafeZipEntry zipEntry = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(srcFile);
            SafeZipInputStream zipInputStream = new SafeZipInputStream(new BufferedInputStream(fileInputStream));
            while ((zipEntry = (SafeZipEntry)zipInputStream.getNextEntry()) != null) {
                if (zipEntry.isDirectory()) continue;
                String entryName = zipEntry.getName();
                File target = new File(srcFile.getParent(), entryName);
                if (!target.getParentFile().exists()) {
                    target.getParentFile().mkdirs();
                }
                FileOutputStream fileOutputStream = new FileOutputStream(target);
                BufferedOutputStream bos = new BufferedOutputStream(new BufferedOutputStream(fileOutputStream));
                int read = 0;
                byte[] buffer = new byte[10240];
                while ((read = zipInputStream.read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, read);
                }
                bos.flush();
            }
            zipInputStream.close();
            flag = true;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return flag;
    }

    public static boolean unZipFolder(String zipFileString, String outPathString) {
        boolean flag = false;
        try {
            ZipEntry zipEntry;
            ZipInputStream inZip = new ZipInputStream(new FileInputStream(zipFileString));
            String szName = "";
            while ((zipEntry = inZip.getNextEntry()) != null) {
                int len;
                szName = zipEntry.getName();
                if (zipEntry.isDirectory()) {
                    szName = szName.substring(0, szName.length() - 1);
                    File folder = new File(outPathString + File.separator + szName);
                    folder.mkdirs();
                    continue;
                }
                Log.e((String)"ZipUtils", (String)(outPathString + File.separator + szName));
                File file = new File(outPathString + File.separator + szName);
                if (!file.exists()) {
                    file.getParentFile().mkdirs();
                    file.createNewFile();
                }
                FileOutputStream out = new FileOutputStream(file);
                byte[] buffer = new byte[1024];
                while ((len = inZip.read(buffer)) != -1) {
                    out.write(buffer, 0, len);
                    out.flush();
                }
                out.close();
            }
            inZip.close();
            flag = true;
        }
        catch (Exception e) {
            Log.e((String)"ZipUtils", (String)("e = " + e.getMessage()));
            e.printStackTrace();
        }
        return flag;
    }
}

