/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk;

import android.content.Context;
import android.util.Log;
import com.baidu.idl.main.facesdk.FaceInfo;
import com.baidu.idl.main.facesdk.FaceQueue;
import com.baidu.idl.main.facesdk.callback.Callback;
import com.baidu.idl.main.facesdk.model.BDFaceImageInstance;
import com.baidu.idl.main.facesdk.model.BDFaceInstance;
import com.baidu.idl.main.facesdk.utils.FileUitls;

public class FaceMouthMask {
    private static final String TAG = FaceMouthMask.class.getSimpleName();
    private BDFaceInstance bdFaceInstance;

    public FaceMouthMask(BDFaceInstance thisBdFaceInstance) {
        if (thisBdFaceInstance == null) {
            return;
        }
        this.bdFaceInstance = thisBdFaceInstance;
    }

    public FaceMouthMask() {
        this.bdFaceInstance = new BDFaceInstance();
        this.bdFaceInstance.getDefautlInstance();
    }

    public void initModel(final Context context, final String mouthMaskModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceMouthMask.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int status = -1;
                byte[] maskModelContent = FileUitls.getModelContent(context, mouthMaskModel);
                if (maskModelContent.length != 0 && (status = FaceMouthMask.this.nativeInitModel(instanceIndex, maskModelContent)) != 0) {
                    callback.onResponse(status, "\u53e3\u7f69\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                if (status == 0) {
                    callback.onResponse(0, "\u53e3\u7f69\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                } else {
                    callback.onResponse(1, "\u53e3\u7f69\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                }
                Log.e((String)"bdface", (String)"FaceMouthMask initModel");
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public float[] checkMask(BDFaceImageInstance bdFaceImageInstance, FaceInfo[] faceInfos) {
        if (bdFaceImageInstance == null || faceInfos == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        return this.nativeCheckMask(instanceIndex, bdFaceImageInstance, faceInfos);
    }

    public int uninitModel() {
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1;
        }
        return this.nativeUninitModel(this.bdFaceInstance.getIndex());
    }

    private native float[] nativeCheckMask(long var1, BDFaceImageInstance var3, FaceInfo[] var4);

    private native int nativeInitModel(long var1, byte[] var3);

    private native int nativeUninitModel(long var1);
}

