/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk;

import android.content.Context;
import android.util.Log;
import com.baidu.idl.main.facesdk.FaceQueue;
import com.baidu.idl.main.facesdk.callback.Callback;
import com.baidu.idl.main.facesdk.model.BDFaceImageInstance;
import com.baidu.idl.main.facesdk.model.BDFaceInstance;
import com.baidu.idl.main.facesdk.model.BDFaceSDKActionConfig;
import com.baidu.idl.main.facesdk.model.BDFaceSDKCommon;
import com.baidu.idl.main.facesdk.utils.FileUitls;
import java.util.concurrent.atomic.AtomicInteger;

public class FaceActionLive {
    private static final String TAG = FaceActionLive.class.getSimpleName();
    private BDFaceInstance bdFaceInstance;
    private int[] isExist = new int[1];

    public FaceActionLive(BDFaceInstance thisBdFaceInstance) {
        if (thisBdFaceInstance == null) {
            return;
        }
        this.bdFaceInstance = thisBdFaceInstance;
    }

    public FaceActionLive() {
        this.bdFaceInstance = new BDFaceInstance();
        this.bdFaceInstance.getDefautlInstance();
    }

    public void initActionLiveModel(final Context context, final String eyecloseModel, final String mouthcloseModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceActionLive.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int statusClose = -1;
                byte[] eyecloseModelContent = FileUitls.getModelContent(context, eyecloseModel);
                byte[] mouthcloseModelContent = FileUitls.getModelContent(context, mouthcloseModel);
                if (eyecloseModelContent.length != 0 && mouthcloseModelContent.length != 0) {
                    statusClose = FaceActionLive.this.nativeActionLiveModelInit(instanceIndex, eyecloseModelContent, mouthcloseModelContent);
                    if (statusClose == 0) {
                        callback.onResponse(statusClose, "\u52a8\u4f5c\u6d3b\u4f53\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                    } else {
                        callback.onResponse(statusClose, "\u52a8\u4f5c\u6d3b\u4f53\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                        return;
                    }
                }
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public void loadActionConfig(BDFaceSDKActionConfig config) {
        if (this.bdFaceInstance == null) {
            return;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return;
        }
        this.nativeActionLoadConfig(instanceIndex, config);
    }

    public int actionLive(BDFaceSDKCommon.BDFaceActionLiveType type, BDFaceImageInstance imageInstance, float[] landmarks, AtomicInteger exist) {
        if (imageInstance == null || landmarks == null || type == null || exist == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return -1;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1;
        }
        int status = this.nativeActionLive(instanceIndex, type.ordinal(), imageInstance, landmarks, this.isExist);
        exist.set(this.isExist[0]);
        return status;
    }

    public int clearHistory() {
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1;
        }
        return this.nativeClearHistory(instanceIndex);
    }

    public int uninitActionLiveModel() {
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1;
        }
        return this.nativeUninitActionLiveModel(instanceIndex);
    }

    private native int nativeActionLiveModelInit(long var1, byte[] var3, byte[] var4);

    private native void nativeActionLoadConfig(long var1, BDFaceSDKActionConfig var3);

    private native int nativeActionLive(long var1, int var3, BDFaceImageInstance var4, float[] var5, int[] var6);

    private native int nativeClearHistory(long var1);

    private native int nativeUninitActionLiveModel(long var1);
}

