/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk;

import android.content.Context;
import com.baidu.idl.main.facesdk.FaceQueue;
import com.baidu.idl.main.facesdk.callback.Callback;
import com.baidu.idl.main.facesdk.model.BDFaceGazeInfo;
import com.baidu.idl.main.facesdk.model.BDFaceImageInstance;
import com.baidu.idl.main.facesdk.model.BDFaceInstance;
import com.baidu.idl.main.facesdk.utils.FileUitls;

public class FaceGaze {
    private static final String TAG = FaceGaze.class.getSimpleName();
    private BDFaceInstance bdFaceInstance;

    public FaceGaze(BDFaceInstance thisBdFaceInstance) {
        if (thisBdFaceInstance == null) {
            return;
        }
        this.bdFaceInstance = thisBdFaceInstance;
    }

    public FaceGaze() {
        this.bdFaceInstance = new BDFaceInstance();
        this.bdFaceInstance.getDefautlInstance();
    }

    public void initModel(final Context context, final String gazeModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceGaze.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int status = -1;
                byte[] modelContent = FileUitls.getModelContent(context, gazeModel);
                if (modelContent.length != 0 && (status = FaceGaze.this.nativeGazeModelInit(instanceIndex, modelContent)) != 0) {
                    callback.onResponse(status, "\u6ce8\u610f\u529b\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                if (status == 0) {
                    callback.onResponse(0, "\u6ce8\u610f\u529b\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                } else {
                    callback.onResponse(1, "\u6ce8\u610f\u529b\u68c0\u6d4b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                }
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public BDFaceGazeInfo gaze(BDFaceImageInstance imageInstance, float[] landmarks) {
        if (imageInstance == null || landmarks == null || landmarks.length < 0) {
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        return this.nativeGaze(instanceIndex, imageInstance, landmarks);
    }

    public int uninitGazeModel() {
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1;
        }
        return this.nativeUninitGazeModel(instanceIndex);
    }

    private native int nativeGazeModelInit(long var1, byte[] var3);

    private native BDFaceGazeInfo nativeGaze(long var1, BDFaceImageInstance var3, float[] var4);

    private native int nativeUninitGazeModel(long var1);
}

