/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk.statistic;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.baidu.idl.main.facesdk.callback.Callback;
import com.baidu.idl.main.facesdk.statistic.DeviceInfoUtil;
import com.baidu.idl.main.facesdk.statistic.NetWorkUtil;
import com.baidu.vis.unified.license.AndroidLicenser;
import com.baidu.vis.unified.license.HttpStatus;
import com.baidu.vis.unified.license.HttpUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class PostDeviceInfo {
    public static void uploadDeviceInfo(final Context context, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                String fingerPrint = AndroidLicenser.getDeviceId((Context)context.getApplicationContext());
                String versionStr = DeviceInfoUtil.getSystemVersion();
                Long ramLong = DeviceInfoUtil.getRamInfo(context);
                float ramFloat = ramLong / 1024L / 1024L;
                int frequenceInt = DeviceInfoUtil.getDeviceBasicFrequency();
                float frequenceFloat = frequenceInt / 1000;
                int cpuCore = DeviceInfoUtil.getNumberOfCPUCores();
                int cpuBit = DeviceInfoUtil.getCPUBit();
                Integer network = NetWorkUtil.getNetworkState(context);
                String facesdkVersion = "4.1";
                String paraStr = null;
                try {
                    JSONObject itemObject = new JSONObject();
                    itemObject.put("analysisType", (Object)"offline_Sdk");
                    itemObject.put("deviceId", (Object)fingerPrint);
                    itemObject.put("cpuCore", cpuCore);
                    itemObject.put("cpuBit", cpuBit);
                    itemObject.put("ghz", Math.round(frequenceFloat));
                    itemObject.put("ram", Math.round(ramFloat));
                    itemObject.put("networkType", (Object)network);
                    String networkDesp = null;
                    networkDesp = network == 1 ? "WIFI\u7f51\u7edc" : (network == 2 ? "2G\u7f51\u7edc" : (network == 3 ? "3G\u7f51\u7edc" : (network == 4 ? "4G\u7f51\u7edc" : (network == 5 ? "\u6709\u7ebf\u7f51\u5361" : "\u5176\u4ed6\u7f51\u7edc\u6a21\u5757"))));
                    itemObject.put("networkDesc", (Object)networkDesp);
                    itemObject.put("os", 1);
                    itemObject.put("osVersion", (Object)versionStr);
                    itemObject.put("sdk", 1);
                    itemObject.put("sdkVersion", (Object)facesdkVersion);
                    JSONObject object = new JSONObject();
                    object.put("mh", (Object)"offlineSdkStatistic");
                    object.put("dt", (Object)itemObject);
                    paraStr = object.toString();
                    Log.i((String)"bdface", (String)("\u53c2\u6570\u662f\uff1a" + paraStr));
                }
                catch (JSONException e) {
                    e.getStackTrace();
                }
                String urlStr = "";
                HttpStatus httpStatus = HttpUtils.requestPost((String)urlStr, paraStr, (String)"application/json", (String)"zxq");
                if (httpStatus == null) {
                    callback.onResponse(-1, "\u8bf7\u6c42\u5931\u8d25");
                    return;
                }
                String response = httpStatus.responseStr;
                Log.i((String)"bdface", (String)("response\u7ed3\u679c\uff1a" + response));
                int responseCode = 1;
                try {
                    if (TextUtils.isEmpty((CharSequence)response)) {
                        callback.onResponse(-1, "request error");
                    } else {
                        JSONObject jsonobject = new JSONObject(response);
                        responseCode = jsonobject.optInt("code");
                        String msg = jsonobject.optString("msg");
                        callback.onResponse(responseCode, msg);
                    }
                }
                catch (JSONException e) {
                    e.getStackTrace();
                    callback.onResponse(-1, "request error = " + e.getMessage());
                }
                catch (Exception e) {
                    e.getStackTrace();
                    callback.onResponse(-1, "request error = " + e.getMessage());
                }
            }
        };
        new Thread(runnable).start();
    }
}

