/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk;

import android.content.Context;
import android.util.Log;
import com.baidu.idl.main.facesdk.FaceQueue;
import com.baidu.idl.main.facesdk.callback.Callback;
import com.baidu.idl.main.facesdk.model.BDFaceImageInstance;
import com.baidu.idl.main.facesdk.model.BDFaceInstance;
import com.baidu.idl.main.facesdk.model.BDFaceSDKCommon;
import com.baidu.idl.main.facesdk.model.Feature;
import com.baidu.idl.main.facesdk.utils.FileUitls;
import java.util.ArrayList;
import java.util.List;

public class FaceFeature {
    private static final String TAG = FaceFeature.class.getSimpleName();
    private BDFaceInstance bdFaceInstance;

    public FaceFeature(BDFaceInstance thisBdFaceInstance) {
        if (thisBdFaceInstance == null) {
            return;
        }
        this.bdFaceInstance = thisBdFaceInstance;
    }

    public FaceFeature() {
        this.bdFaceInstance = new BDFaceInstance();
        this.bdFaceInstance.getDefautlInstance();
    }

    public void initModel(final Context context, final String idPhotoModel, final String visModel, String nirModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceFeature.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int statusId = -1;
                byte[] idPhotoModelContent = FileUitls.getModelContent(context, idPhotoModel);
                if (idPhotoModelContent.length != 0 && (statusId = FaceFeature.this.nativeFeatureModelInit(instanceIndex, idPhotoModelContent, BDFaceSDKCommon.FeatureType.BDFACE_FEATURE_TYPE_ID_PHOTO.ordinal())) != 0) {
                    callback.onResponse(statusId, "\u8bc1\u4ef6\u7167\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                int statusVis = -1;
                byte[] visModelContent = FileUitls.getModelContent(context, visModel);
                if (visModelContent.length != 0 && (statusVis = FaceFeature.this.nativeFeatureModelInit(instanceIndex, visModelContent, BDFaceSDKCommon.FeatureType.BDFACE_FEATURE_TYPE_LIVE_PHOTO.ordinal())) != 0) {
                    callback.onResponse(statusVis, "Vis \u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                    return;
                }
                if (statusId == 0 || statusVis == 0) {
                    callback.onResponse(0, "\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
                } else {
                    callback.onResponse(1, "\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                }
                Log.v((String)TAG, (String)"FaceFeature initModel");
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public void initModel(final Context context, final String idPhotoModel, final String visModel, final String nirModel, final String rgbdModel, final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                byte[] modelContent;
                if (idPhotoModel.length() == 0 && visModel.length() == 0 && nirModel.length() == 0 && rgbdModel.length() == 0) {
                    Log.v((String)TAG, (String)"FaceFeature\u672a\u8bbe\u7f6e\u6a21\u578b\u8def\u5f84");
                    callback.onResponse(1, "FaceFeature\u672a\u8bbe\u7f6e\u6a21\u578b\u8def\u5f84");
                    return;
                }
                if (context == null) {
                    callback.onResponse(1, "\u6ca1\u6709\u521d\u59cb\u5316\u4e0a\u4e0b\u6587");
                    return;
                }
                long instanceIndex = FaceFeature.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    return;
                }
                int statusIdPhoto = -1;
                if (idPhotoModel.length() != 0) {
                    modelContent = FileUitls.getModelContent(context, idPhotoModel);
                    if (modelContent.length == 0) {
                        Log.v((String)TAG, (String)"\u8bc1\u4ef6\u7167\u8bc6\u522b\u6a21\u578b\u8bfb\u53d6\u5931\u8d25");
                        callback.onResponse(statusIdPhoto, "\u8bc1\u4ef6\u7167\u8bc6\u522b\u6a21\u578b\u8bfb\u53d6\u5931\u8d25");
                        return;
                    }
                    statusIdPhoto = FaceFeature.this.nativeFeatureModelInit(instanceIndex, modelContent, BDFaceSDKCommon.FeatureType.BDFACE_FEATURE_TYPE_ID_PHOTO.ordinal());
                    if (statusIdPhoto != 0) {
                        Log.v((String)TAG, (String)("\u8bc1\u4ef6\u7167\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25: " + statusIdPhoto));
                        callback.onResponse(statusIdPhoto, "\u8bc1\u4ef6\u7167\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                        return;
                    }
                }
                int statusLivePhoto = -1;
                if (visModel.length() != 0) {
                    modelContent = FileUitls.getModelContent(context, visModel);
                    if (modelContent.length == 0) {
                        Log.v((String)TAG, (String)"\u751f\u6d3b\u7167\u8bc6\u522b\u6a21\u578b\u8bfb\u53d6\u5931\u8d25");
                        callback.onResponse(statusLivePhoto, "\u751f\u6d3b\u7167\u8bc6\u522b\u6a21\u578b\u8bfb\u53d6\u5931\u8d25");
                        return;
                    }
                    statusLivePhoto = FaceFeature.this.nativeFeatureModelInit(instanceIndex, modelContent, BDFaceSDKCommon.FeatureType.BDFACE_FEATURE_TYPE_LIVE_PHOTO.ordinal());
                    if (statusLivePhoto != 0) {
                        Log.v((String)TAG, (String)("\u751f\u6d3b\u7167\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25: " + statusLivePhoto));
                        callback.onResponse(statusLivePhoto, "\u751f\u6d3b\u7167\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                        return;
                    }
                }
                int statusNirPhoto = -1;
                if (nirModel.length() != 0) {
                    modelContent = FileUitls.getModelContent(context, nirModel);
                    if (modelContent.length == 0) {
                        Log.v((String)TAG, (String)"Nir\u8bc6\u522b\u6a21\u578b\u8bfb\u53d6\u5931\u8d25");
                        callback.onResponse(statusNirPhoto, "Nir\u8bc6\u522b\u6a21\u578b\u8bfb\u53d6\u5931\u8d25");
                        return;
                    }
                    statusNirPhoto = FaceFeature.this.nativeFeatureModelInit(instanceIndex, modelContent, BDFaceSDKCommon.FeatureType.BDFACE_FEATURE_TYPE_NIR.ordinal());
                    if (statusNirPhoto != 0) {
                        Log.v((String)TAG, (String)("Nir\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25: " + statusNirPhoto));
                        callback.onResponse(statusNirPhoto, "Nir\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                        return;
                    }
                }
                int statusRGBDPhoto = -1;
                if (rgbdModel.length() != 0) {
                    modelContent = FileUitls.getModelContent(context, rgbdModel);
                    if (modelContent.length == 0) {
                        Log.v((String)TAG, (String)"rgbd\u8bc6\u522b\u6a21\u578b\u8bfb\u53d6\u5931\u8d25");
                        callback.onResponse(statusRGBDPhoto, "rgbd\u8bc6\u522b\u6a21\u578b\u8bfb\u53d6\u5931\u8d25");
                        return;
                    }
                    statusRGBDPhoto = FaceFeature.this.nativeFeatureModelInit(instanceIndex, modelContent, BDFaceSDKCommon.FeatureType.BDFACE_FEATURE_TYPE_RGBD.ordinal());
                    if (statusRGBDPhoto != 0) {
                        Log.v((String)TAG, (String)("rgbd\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25: " + statusRGBDPhoto));
                        callback.onResponse(statusRGBDPhoto, "rgbd\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u5931\u8d25");
                        return;
                    }
                }
                Log.v((String)TAG, (String)"FaceFeature initModel");
                callback.onResponse(0, "\u8bc6\u522b\u6a21\u578b\u52a0\u8f7d\u6210\u529f");
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public float feature(BDFaceSDKCommon.FeatureType featureType, BDFaceImageInstance imageInstance, float[] landmarks, byte[] feature) {
        if (featureType == null || landmarks == null || feature == null || imageInstance == null || landmarks.length < 0) {
            Log.v((String)TAG, (String)"Parameter is null");
            return -1.0f;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1.0f;
        }
        return this.nativeFeature(instanceIndex, featureType.ordinal(), imageInstance, landmarks, feature);
    }

    public float featureRGBD(BDFaceSDKCommon.FeatureType featureType, BDFaceImageInstance imageInstance, BDFaceImageInstance imageInstance_depth, float[] landmarks, byte[] feature) {
        if (featureType == null || landmarks == null || feature == null || imageInstance == null || imageInstance_depth == null || landmarks.length < 0) {
            Log.v((String)TAG, (String)"Parameter is null");
            return -1.0f;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1.0f;
        }
        return this.nativeRGBDFeature(instanceIndex, featureType.ordinal(), imageInstance, imageInstance_depth, landmarks, feature);
    }

    public float featureCompare(BDFaceSDKCommon.FeatureType featureType, byte[] feature1, byte[] feature2, boolean isPercent) {
        if (featureType == null || feature1 == null || feature2 == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return -1.0f;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1.0f;
        }
        return this.nativeFeatureCompare(instanceIndex, featureType.ordinal(), feature1, feature2, isPercent ? 1 : 0);
    }

    public int featurePush(List<? extends Feature> features) {
        return -1;
    }

    public ArrayList<Feature> featureSearch(byte[] firstFaceFeature, BDFaceSDKCommon.FeatureType featureType, int topNum, boolean isPercent) {
        return null;
    }

    public int uninitModel() {
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1;
        }
        return this.nativeUninitModel(instanceIndex);
    }

    private native int nativeFeatureModelInit(long var1, byte[] var3, int var4);

    private native float nativeFeatureCompare(long var1, int var3, byte[] var4, byte[] var5, int var6);

    private native float nativeFeature(long var1, int var3, BDFaceImageInstance var4, float[] var5, byte[] var6);

    private native float nativeRGBDFeature(long var1, int var3, BDFaceImageInstance var4, BDFaceImageInstance var5, float[] var6, byte[] var7);

    private native int nativefeaturePush(List<? extends Feature> var1);

    private native ArrayList<Feature> nativeFeatureSearch(long var1, byte[] var3, int var4, int var5, int var6);

    private native int nativeUninitModel(long var1);
}

