/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.face.platform.utils;

import android.content.Context;
import android.os.Build;
import android.text.TextUtils;
import com.baidu.idl.face.platform.utils.APIUtils;

public final class DensityUtils {
    private static final float DOT_FIVE = 0.5f;
    private static final int PORTRAIT_DEGREE_90 = 90;
    private static final int PORTRAIT_DEGREE_270 = 270;
    private static final String[] BUILD_MODELS = new String[]{"i700v", "A862W", "V8526"};

    private DensityUtils() {
    }

    public static int sp2px(Context context, float spValue) {
        float fontScale = context.getResources().getDisplayMetrics().scaledDensity;
        return (int)(spValue * fontScale + 0.5f);
    }

    public static int dip2px(Context context, float dip) {
        float density = DensityUtils.getDensity(context);
        return (int)(dip * density + 0.5f);
    }

    public static int px2dip(Context context, float px) {
        float density = DensityUtils.getDensity(context);
        return (int)(px / density + 0.5f);
    }

    public static int getDisplayWidth(Context context) {
        return context.getResources().getDisplayMetrics().widthPixels;
    }

    public static int getDisplayHeight(Context context) {
        return context.getResources().getDisplayMetrics().heightPixels;
    }

    public static float getDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    public static int getDensityDpi(Context context) {
        return context.getResources().getDisplayMetrics().densityDpi;
    }

    public static boolean supportCameraPortrait() {
        return APIUtils.hasFroyo() && !TextUtils.equals((CharSequence)"GT-S5830i", (CharSequence)Build.PRODUCT);
    }

    public static int getPortraitDegree() {
        int degree = 90;
        for (String model : BUILD_MODELS) {
            if (!TextUtils.equals((CharSequence)model, (CharSequence)Build.MODEL)) continue;
            degree = 270;
            break;
        }
        return degree;
    }
}

