/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk.utils;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

@SuppressLint(value={"NewApi"})
public class PreferencesUtil {
    private static SharedPreferences mPrefs;
    private static final String LENGTH_SUFFIX = "#LENGTH";
    private static final String LEFT_MOUNT = "[";
    private static final String RIGHT_MOUNT = "]";

    public static void initPrefs(Context context) {
        if (mPrefs == null) {
            String key = context.getPackageName();
            if (key == null) {
                throw new NullPointerException("Prefs key may not be null");
            }
            mPrefs = context.getSharedPreferences(key, 4);
        }
    }

    @Deprecated
    public static void reInit(Context context) {
        if (context != null) {
            String key = context.getPackageName();
            if (key == null) {
                throw new NullPointerException("Prefs key may not be null");
            }
            mPrefs = context.getSharedPreferences(key, 4);
        }
    }

    public static SharedPreferences getPreferences() {
        if (mPrefs != null) {
            return mPrefs;
        }
        throw new RuntimeException("please call iniPrefs(context) in the Application class onCreate.");
    }

    public static Map<String, ?> getAll() {
        return PreferencesUtil.getPreferences().getAll();
    }

    public static int getInt(String key, int defValue) {
        return PreferencesUtil.getPreferences().getInt(key, defValue);
    }

    public static boolean getBoolean(String key, boolean defValue) {
        return PreferencesUtil.getPreferences().getBoolean(key, defValue);
    }

    public static long getLong(String key, long defValue) {
        return PreferencesUtil.getPreferences().getLong(key, defValue);
    }

    public static float getFloat(String key, float defValue) {
        return PreferencesUtil.getPreferences().getFloat(key, defValue);
    }

    public static String getString(String key, String defValue) {
        return PreferencesUtil.getPreferences().getString(key, defValue);
    }

    @TargetApi(value=11)
    public static Set<String> getStringSet(String key, Set<String> defValue) {
        SharedPreferences prefs = PreferencesUtil.getPreferences();
        if (Build.VERSION.SDK_INT >= 11) {
            return prefs.getStringSet(key, defValue);
        }
        if (prefs.contains(key + LENGTH_SUFFIX)) {
            HashSet<String> set = new HashSet<String>();
            int stringSetLength = prefs.getInt(key + LENGTH_SUFFIX, -1);
            if (stringSetLength >= 0) {
                for (int i = 0; i < stringSetLength; ++i) {
                    prefs.getString(key + LEFT_MOUNT + i + RIGHT_MOUNT, null);
                }
            }
            return set;
        }
        return defValue;
    }

    public static void putLong(String key, long value) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        editor.putLong(key, value);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putInt(String key, int value) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        editor.putInt(key, value);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putFloat(String key, float value) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        editor.putFloat(key, value);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putBoolean(String key, boolean value) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        editor.putBoolean(key, value);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void putString(String key, String value) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        editor.putString(key, value);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    @TargetApi(value=11)
    public static void putStringSet(String key, Set<String> value) {
        SharedPreferences.Editor editor = PreferencesUtil.getPreferences().edit();
        if (Build.VERSION.SDK_INT >= 11) {
            editor.putStringSet(key, value);
        } else {
            int stringSetLength = 0;
            if (mPrefs.contains(key + LENGTH_SUFFIX)) {
                stringSetLength = mPrefs.getInt(key + LENGTH_SUFFIX, -1);
            }
            editor.putInt(key + LENGTH_SUFFIX, value.size());
            int i = 0;
            for (String aValue : value) {
                editor.putString(key + LEFT_MOUNT + i + RIGHT_MOUNT, aValue);
                ++i;
            }
            while (i < stringSetLength) {
                editor.remove(key + LEFT_MOUNT + i + RIGHT_MOUNT);
                ++i;
            }
        }
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static void remove(String key) {
        int stringSetLength;
        SharedPreferences prefs = PreferencesUtil.getPreferences();
        SharedPreferences.Editor editor = prefs.edit();
        if (prefs.contains(key + LENGTH_SUFFIX) && (stringSetLength = prefs.getInt(key + LENGTH_SUFFIX, -1)) >= 0) {
            editor.remove(key + LENGTH_SUFFIX);
            for (int i = 0; i < stringSetLength; ++i) {
                editor.remove(key + LEFT_MOUNT + i + RIGHT_MOUNT);
            }
        }
        editor.remove(key);
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }

    public static boolean contains(String key) {
        return PreferencesUtil.getPreferences().contains(key);
    }
}

