/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk.statistic;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.StatFs;
import android.os.storage.StorageManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceInfoUtil {
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (path.charAt(i) >= '0' && path.charAt(i) <= '9') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static final String CurPath = "/sys/devices/system/cpu/cpu0/cpufreq/scaling_cur_freq";

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static int getDeviceSDK() {
        return Build.VERSION.SDK_INT;
    }

    public static String getDeviceSerial() {
        return Build.SERIAL;
    }

    public static String getDeviceBrand() {
        return Build.BRAND;
    }

    public static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    public static String getDeviceProduct() {
        return Build.PRODUCT;
    }

    public static String getDeviceModel() {
        return Build.MODEL;
    }

    public static String getDeviceBoard() {
        return Build.BOARD;
    }

    public static String getDeviceDevice() {
        return Build.DEVICE;
    }

    public static String getDeviceProcessor() {
        Object processor = null;
        try {
            FileReader fr = new FileReader("/proc/cpuinfo");
            BufferedReader br = new BufferedReader(fr);
            String text = br.readLine();
            String[] array = text.split(":\\s+", 2);
            for (int i = 0; i < array.length; ++i) {
            }
            return array[1];
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int getNumberOfCPUCores() {
        int cores;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
        }
        catch (SecurityException e) {
            cores = 0;
        }
        catch (NullPointerException e) {
            cores = 0;
        }
        return cores;
    }

    public static Integer getCPUBit() {
        Integer result = 0;
        String mProcessor = null;
        try {
            mProcessor = DeviceInfoUtil.getFieldFromCpuinfo("Processor");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (mProcessor != null) {
            result = mProcessor.contains("aarch64") ? Integer.valueOf(64) : Integer.valueOf(32);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getFieldFromCpuinfo(String field) throws IOException {
        Pattern p = Pattern.compile(field + "\\s*:\\s*(.*)");
        try (BufferedReader br = new BufferedReader(new FileReader("/proc/cpuinfo"));){
            String line;
            while ((line = br.readLine()) != null) {
                Matcher m = p.matcher(line);
                if (!m.matches()) continue;
                String string = m.group(1);
                return string;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getDeviceBasicFrequency() {
        int result = 0;
        FileReader fr = null;
        BufferedReader br = null;
        try {
            fr = new FileReader(CurPath);
            br = new BufferedReader(fr);
            String text = br.readLine();
            result = Integer.parseInt(text.trim());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fr != null) {
                try {
                    fr.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return result;
    }

    public static long getRamInfo(Context context) {
        long totalSize = 0L;
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
        manager.getMemoryInfo(memoryInfo);
        totalSize = memoryInfo.totalMem;
        return totalSize;
    }

    public static String getStorageInfo(Context context, int type) {
        String storageInfo;
        String path = DeviceInfoUtil.getStoragePath(context, type);
        if (!DeviceInfoUtil.isSDCardMount() || path == null || path.toString().equals("")) {
            storageInfo = "\u65e0\u5916\u7f6eSD\u5361";
        } else {
            File file = new File(path);
            StatFs statFs = new StatFs(file.getPath());
            long blockCount = statFs.getBlockCountLong();
            long blockSize = statFs.getBlockSizeLong();
            long totalSpace = blockCount * blockSize;
            long aviableBlocks = statFs.getAvailableBlocksLong();
            long aviableSpace = aviableBlocks * blockSize;
            storageInfo = "\u53ef\u7528/\u603b\u5171\uff1a" + Long.toString(aviableSpace) + "/" + Long.toString(totalSpace);
        }
        return storageInfo;
    }

    public static boolean isSDCardMount() {
        return Environment.getExternalStorageState().equals("mounted");
    }

    public static String getStoragePath(Context context, int type) {
        StorageManager storageManager = (StorageManager)context.getSystemService("storage");
        try {
            Method getPathMethod = storageManager.getClass().getMethod("getVolumePaths", new Class[0]);
            String[] path = (String[])getPathMethod.invoke((Object)storageManager, new Object[0]);
            switch (type) {
                case 0: {
                    return path[type];
                }
                case 1: {
                    if (path.length > 1) {
                        return path[type];
                    }
                    return null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

