/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.idl.main.facesdk;

import android.util.Log;
import com.baidu.idl.main.facesdk.FaceInfo;
import com.baidu.idl.main.facesdk.FaceQueue;
import com.baidu.idl.main.facesdk.callback.Callback;
import com.baidu.idl.main.facesdk.model.BDFaceCropParam;
import com.baidu.idl.main.facesdk.model.BDFaceImageInstance;
import com.baidu.idl.main.facesdk.model.BDFaceInstance;
import com.baidu.idl.main.facesdk.model.BDFaceIsOutBoundary;
import com.baidu.idl.main.facesdk.model.BDFaceSDKCommon;
import java.util.concurrent.atomic.AtomicInteger;

public class FaceCrop {
    private static final String TAG = FaceCrop.class.getSimpleName();
    private BDFaceInstance bdFaceInstance;

    public FaceCrop(BDFaceInstance thisBdFaceInstance) {
        if (thisBdFaceInstance == null) {
            return;
        }
        this.bdFaceInstance = thisBdFaceInstance;
    }

    public FaceCrop() {
        this.bdFaceInstance = new BDFaceInstance();
        this.bdFaceInstance.getDefautlInstance();
    }

    public void initFaceCrop(final Callback callback) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                long instanceIndex = FaceCrop.this.bdFaceInstance.getIndex();
                if (instanceIndex == 0L) {
                    callback.onResponse(-1, "\u62a0\u56fe\u80fd\u529b\u52a0\u8f7d\u5931\u8d25 instanceIndex=0");
                    return;
                }
                int status = FaceCrop.this.nativeCropImageInit(instanceIndex);
                if (status != 0) {
                    callback.onResponse(status, "\u62a0\u56fe\u80fd\u529b\u52a0\u8f7d\u5931\u8d25: " + status);
                    return;
                }
                callback.onResponse(status, "\u62a0\u56fe\u80fd\u529b\u52a0\u8f7d\u6210\u529f");
            }
        };
        FaceQueue.getInstance().execute(runnable);
    }

    public int uninitFaceCrop() {
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return -1;
        }
        return this.nativeUnInitCropImage(instanceIndex);
    }

    public BDFaceImageInstance cropFaceByBox(BDFaceImageInstance imageInstance, FaceInfo faceinfo, float enlargeRatio, AtomicInteger isOutofBoundary) {
        if (imageInstance == null || faceinfo == null || isOutofBoundary == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        int[] isOutofBoundary_temp = new int[1];
        BDFaceImageInstance img_crop = this.nativeCropFaceByBox(instanceIndex, imageInstance, faceinfo, enlargeRatio, isOutofBoundary_temp);
        isOutofBoundary.set(isOutofBoundary_temp[0]);
        return img_crop;
    }

    public BDFaceImageInstance cropFaceByLandmark(BDFaceImageInstance imageInstance, float[] landmark, float enlargeRatio, boolean correction, AtomicInteger isOutofBoundary) {
        if (imageInstance == null || isOutofBoundary == null || landmark.length < 0) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        int[] isOutofBoundary_temp = new int[1];
        BDFaceImageInstance img_crop = this.nativeCropFaceByLandmark(instanceIndex, imageInstance, landmark, enlargeRatio, correction, isOutofBoundary_temp);
        isOutofBoundary.set(isOutofBoundary_temp[0]);
        return img_crop;
    }

    public BDFaceImageInstance resizeImage(BDFaceImageInstance imageInstance, int size) {
        if (imageInstance == null) {
            return null;
        }
        return this.nativeResizeImage(imageInstance, size, imageInstance.imageType);
    }

    public BDFaceIsOutBoundary cropFaceByBoxIsOutofBoundary(BDFaceImageInstance imageInstance, FaceInfo faceinfo, BDFaceCropParam cropParam) {
        if (imageInstance == null || faceinfo == null || cropParam == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        return this.nativeCropFaceByBoxIsOutofBoundary(instanceIndex, imageInstance, faceinfo, cropParam);
    }

    public BDFaceIsOutBoundary cropFaceByLandmarkIsOutofBoundary(BDFaceImageInstance imageInstance, float[] landmark, BDFaceCropParam cropParam) {
        if (imageInstance == null || landmark == null || cropParam == null || landmark.length == 0) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        return this.nativeCropFaceByLandmarkIsOutofBoundary(instanceIndex, imageInstance, landmark, cropParam);
    }

    public BDFaceImageInstance cropFaceByBoxParam(BDFaceImageInstance imageInstance, FaceInfo faceinfo, BDFaceCropParam cropParam) {
        if (imageInstance == null || faceinfo == null || cropParam == null) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            Log.v((String)TAG, (String)"instanceIndex == 0");
            return null;
        }
        return this.nativeCropFaceByBoxParam(instanceIndex, imageInstance, faceinfo, cropParam);
    }

    public BDFaceImageInstance cropFaceByLandmarkParam(BDFaceImageInstance imageInstance, float[] landmark, BDFaceCropParam cropParam) {
        if (imageInstance == null || landmark == null || cropParam == null || landmark.length == 0) {
            Log.v((String)TAG, (String)"Parameter is null");
            return null;
        }
        long instanceIndex = this.bdFaceInstance.getIndex();
        if (instanceIndex == 0L) {
            return null;
        }
        return this.nativeCropFaceByLandmarkParam(instanceIndex, imageInstance, landmark, cropParam);
    }

    private native BDFaceImageInstance nativeCropFaceByBox(long var1, BDFaceImageInstance var3, FaceInfo var4, float var5, int[] var6);

    private native BDFaceImageInstance nativeCropFaceByLandmark(long var1, BDFaceImageInstance var3, float[] var4, float var5, boolean var6, int[] var7);

    private native int nativeCropImageInit(long var1);

    private native int nativeUnInitCropImage(long var1);

    private native BDFaceImageInstance nativeResizeImage(BDFaceImageInstance var1, int var2, BDFaceSDKCommon.BDFaceImageType var3);

    private native BDFaceIsOutBoundary nativeCropFaceByBoxIsOutofBoundary(long var1, BDFaceImageInstance var3, FaceInfo var4, BDFaceCropParam var5);

    private native BDFaceIsOutBoundary nativeCropFaceByLandmarkIsOutofBoundary(long var1, BDFaceImageInstance var3, float[] var4, BDFaceCropParam var5);

    private native BDFaceImageInstance nativeCropFaceByBoxParam(long var1, BDFaceImageInstance var3, FaceInfo var4, BDFaceCropParam var5);

    private native BDFaceImageInstance nativeCropFaceByLandmarkParam(long var1, BDFaceImageInstance var3, float[] var4, BDFaceCropParam var5);
}

