/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.face.stat;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkCapabilities;
import android.os.Build;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.json.JSONException;

public class NetUtil {
    private static final String TAG = "NetUtil";
    private static final HostnameVerifier DO_NOT_VERIFY = new HostnameVerifier(){

        @Override
        public boolean verify(String hostname, SSLSession session) {
            return true;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void uploadData(RequestAdapter<T> adapter) {
        boolean requireRetry = false;
        int retryCount = adapter.getRetryCount();
        boolean code = false;
        Throwable exception = null;
        Object result = null;
        HttpURLConnection conn = null;
        OutputStream out = null;
        InputStream in = null;
        do {
            int var36;
            try {
                requireRetry = false;
                var36 = 0;
                exception = null;
                result = null;
                URL e = new URL(adapter.getURL());
                NetUtil.trustAllHosts();
                conn = (HttpURLConnection)e.openConnection();
                conn.setConnectTimeout(adapter.getConnectTimeout());
                conn.setDoInput(true);
                conn.setDoOutput(true);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setReadTimeout(adapter.getReadTimeout());
                conn.setRequestMethod(adapter.getRequestMethod());
                conn.setUseCaches(false);
                out = conn.getOutputStream();
                out.write(adapter.getRequestString().getBytes("UTF-8"));
                out.flush();
                if (conn.getResponseCode() != 200) {
                    var36 = 4;
                    exception = new IllegalStateException("ResponseCode: " + conn.getResponseCode());
                    continue;
                }
                in = conn.getInputStream();
                adapter.parseResponse(in);
            }
            catch (SocketTimeoutException var31) {
                var31.printStackTrace();
                requireRetry = true;
                var36 = 1;
                exception = var31;
            }
            catch (IOException var32) {
                var32.printStackTrace();
                var36 = 2;
                exception = var32;
            }
            catch (JSONException var33) {
                var33.printStackTrace();
                var36 = 3;
                exception = var33;
            }
            catch (Exception var34) {
                var34.printStackTrace();
                var36 = 5;
                exception = var34;
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException var31) {}
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException var31) {}
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        } while (requireRetry && retryCount-- > 0);
    }

    @TargetApi(value=23)
    public static boolean isConnected(Context context) {
        if (context == null) {
            return false;
        }
        boolean flag = true;
        if (Build.VERSION.SDK_INT > 23) {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkCapabilities networkCapabilities = connectivityManager.getNetworkCapabilities(connectivityManager.getActiveNetwork());
            flag = networkCapabilities.hasCapability(16);
        }
        return flag;
    }

    private NetUtil() {
        throw new RuntimeException("This class instance can not be created.");
    }

    private static void trustAllHosts() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static abstract class RequestAdapter<T> {
        public static final int RESPONSE_STATUS_NORMAL = 0;
        public static final int RESPONSE_STATUS_ERROR_TIMEOUT = 1;
        public static final int RESPONSE_STATUS_ERROR_IO = 2;
        public static final int RESPONSE_STATUS_ERROR_PARSE_JSON = 3;
        public static final int RESPONSE_STATUS_ERROR_RESPONSE_CODE = 4;
        public static final int RESPONSE_STATUS_ERROR_UNKNOWN = 5;
        private static final int RETRY_COUNT = 2;
        private static final int CONNECT_TIMEOUT = 5000;
        private static final int READ_TIMEOUT = 5000;
        private static final String REQUEST_METHOD = "POST";

        public abstract String getURL();

        public abstract String getRequestString();

        public abstract void parseResponse(InputStream var1) throws IOException, JSONException;

        public int getRetryCount() {
            return 0;
        }

        public int getConnectTimeout() {
            return 5000;
        }

        public int getReadTimeout() {
            return 5000;
        }

        public String getRequestMethod() {
            return REQUEST_METHOD;
        }
    }
}

