/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.face.stat;

import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.UUID;

public class Dev {
    private static final String INSTALLATION = "INSTALLATION";
    private String uniqueID = "";
    private String brand = "";
    private String sysVersion = "";
    private String packagename = "";
    private String sdkVersion = "2.1.0.0";
    private boolean firstRun = false;

    public String getUniqueID() {
        return this.uniqueID;
    }

    public String getBrand() {
        return this.brand;
    }

    public String getSysVersion() {
        return this.sysVersion;
    }

    public String getPackagename() {
        return this.packagename;
    }

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public boolean getFirstRun() {
        return this.firstRun;
    }

    public void setSdkVersion(String sdkVersion) {
        this.sdkVersion = sdkVersion;
    }

    public void setFirstRun(boolean firstRun) {
        this.firstRun = firstRun;
    }

    public void init(Context context) {
        if (context == null) {
            return;
        }
        this.brand = Build.MODEL.replace(" ", "");
        this.sysVersion = Build.VERSION.RELEASE;
        this.packagename = context.getPackageName();
        this.uniqueID = this.getUniqueIdFromFile(context);
        if (TextUtils.isEmpty((CharSequence)this.uniqueID)) {
            this.firstRun = true;
            this.uniqueID = this.generateUniquePsuedoID(context);
            this.writeInstallationFile(context, this.uniqueID);
        }
    }

    public synchronized String getUniqueIdFromFile(Context context) {
        if (TextUtils.isEmpty((CharSequence)this.uniqueID)) {
            File installation = new File(context.getFilesDir(), INSTALLATION);
            try {
                this.uniqueID = this.readInstallationFile(installation);
            }
            catch (IOException e) {
                e.printStackTrace();
                this.uniqueID = "uncreate";
            }
        }
        return this.uniqueID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readInstallationFile(File installation) throws IOException {
        String uniqueId = "";
        try (RandomAccessFile rf = null;){
            rf = new RandomAccessFile(installation, "r");
            byte[] bytes = new byte[(int)rf.length()];
            rf.readFully(bytes);
            uniqueId = new String(bytes);
        }
        return uniqueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeInstallationFile(Context context, String uniqueID) {
        FileOutputStream out = null;
        try {
            File installation = new File(context.getFilesDir(), INSTALLATION);
            out = new FileOutputStream(installation);
            out.write(uniqueID.getBytes());
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String generateUniquePsuedoID(Context context) {
        String m_szDevIDShort = "35" + Build.BOARD.length() % 10 + Build.BRAND.length() % 10 + Build.CPU_ABI.length() % 10 + Build.DEVICE.length() % 10 + Build.MANUFACTURER.length() % 10 + Build.MODEL.length() % 10 + Build.PRODUCT.length() % 10;
        String serial = null;
        try {
            serial = Build.class.getField("SERIAL").get(null).toString();
        }
        catch (Exception e) {
            serial = UUID.randomUUID().toString();
        }
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        if ("9774d56d682e549c".equals(androidId)) {
            androidId = UUID.randomUUID().toString();
        }
        String join = serial + androidId + m_szDevIDShort;
        return Dev.md5(join);
    }

    public static String md5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            BigInteger number = new BigInteger(1, messageDigest);
            String hashtext = number.toString(16);
            while (hashtext.length() < 32) {
                hashtext = "0" + hashtext;
            }
            return hashtext;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }
}

