/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.aip.face.stat;

import android.content.Context;
import android.text.TextUtils;
import android.util.SparseArray;
import com.baidu.aip.face.stat.Dev;
import com.baidu.aip.face.stat.FileUtil;
import com.baidu.aip.face.stat.NetUtil;
import com.baidu.idl.facesdk.FaceInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Ast {
    private static final String AS_FILE_NAME = "ast";
    private static final long UPADTE_DEFUALT_DELAY_TIME = 15000L;
    private static final long SAVE_INTERVAL = 15000L;
    private static Ast instance;
    private Context context;
    private boolean isInit;
    private File asFile;
    private Properties properties;
    private Dev dev;
    private String faceHitKey = "";
    private static final String FACE_HIT_KEY_LASSTTIME = "FACE_HIT_KEY_LASSTTIME";
    private static final String UPLOAD_LASSTTIME = "UPLOAD_LASSTTIME";
    private long lastSavetime;
    private SparseArray<Integer> faceIds = new SparseArray();
    private String scene;
    ExecutorService es = Executors.newSingleThreadExecutor();
    Future future = null;

    private Ast() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Ast getInstance() {
        if (instance != null) return instance;
        Class<Ast> clazz = Ast.class;
        synchronized (Ast.class) {
            instance = new Ast();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean init(Context context, String sdkVersion, String scene) {
        if (this.isInit) {
            return true;
        }
        if (context != null) {
            this.context = context.getApplicationContext();
            this.dev = new Dev();
            this.dev.init(context);
            this.dev.setSdkVersion(sdkVersion);
            this.scene = scene;
            this.initFile();
        }
        return true;
    }

    private String generateFaceHitKey(String indicator) {
        StringBuilder sb = new StringBuilder();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy_MM_dd_HH");
        sb.append(simpleDateFormat.format(new Date())).append("_");
        sb.append(indicator);
        return sb.toString();
    }

    private boolean initFile() {
        this.asFile = new File(this.context.getFilesDir(), AS_FILE_NAME);
        this.properties = new Properties();
        return !FileUtil.createFile(this.asFile) ? false : FileUtil.loadPropertiesFile(this.asFile, this.properties);
    }

    public void faceHit(String indicator, int daleyUpload, FaceInfo[] faceInfos) {
        int hitCount = 0;
        if (faceInfos == null) {
            this.faceIds.clear();
            return;
        }
        for (FaceInfo faceInfo : faceInfos) {
            Integer faceId = (Integer)this.faceIds.get(faceInfo.face_id);
            if (faceId != null) continue;
            this.faceIds.put(faceInfo.face_id, (Object)faceInfo.face_id);
            ++hitCount;
        }
        if (hitCount == 0) {
            return;
        }
        this.faceHit(indicator, (long)daleyUpload, hitCount);
    }

    public void faceHit() {
        this.faceHit("liveness", 15000L, 1);
    }

    public void faceHit(String indicator) {
        this.faceHit(indicator, 15000L, 1);
    }

    public void faceHit(String indicator, int count) {
        this.faceHit(indicator, 15000L, count);
    }

    public void faceHit(String indicator, long daleyUpload, int count) {
        String faceHitKey = this.generateFaceHitKey(indicator);
        String value = this.properties.getProperty(faceHitKey);
        if (TextUtils.isEmpty((CharSequence)value)) {
            this.properties.setProperty(faceHitKey, String.valueOf(count));
            this.properties.setProperty(FACE_HIT_KEY_LASSTTIME, String.valueOf(System.currentTimeMillis()));
        } else {
            int val = Integer.parseInt(value);
            this.properties.setProperty(faceHitKey, String.valueOf(val + count));
        }
        String lasttimeStr = this.properties.getProperty(FACE_HIT_KEY_LASSTTIME);
        long lastSaveTime = 0L;
        try {
            lastSaveTime = Long.parseLong(lasttimeStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (System.currentTimeMillis() - lastSaveTime > 15000L) {
            long starttime = System.currentTimeMillis();
            FileUtil.savePropertiesFile(this.asFile, this.properties);
            this.properties.setProperty(FACE_HIT_KEY_LASSTTIME, String.valueOf(System.currentTimeMillis()));
        }
        String lastUploadTimeStr = this.properties.getProperty(UPLOAD_LASSTTIME);
        long lastUploadtime = 0L;
        try {
            lastUploadtime = Long.parseLong(lastUploadTimeStr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!this.dev.getFirstRun() && System.currentTimeMillis() - lastUploadtime < daleyUpload) {
            return;
        }
        this.sendData();
    }

    public void immediatelyUpload() {
        this.sendData();
    }

    private void clear() {
        this.properties.clear();
    }

    private void sendData() {
        if (this.future != null && !this.future.isDone()) {
            return;
        }
        this.future = this.es.submit(new Runnable(){

            @Override
            public void run() {
                Ast.this.netRequest();
            }
        });
    }

    private void netRequest() {
        if (this.properties.size() == 0) {
            return;
        }
        NetUtil.uploadData(new NetUtil.RequestAdapter<Object>(){

            @Override
            public String getURL() {
                return "http://brain.baidu.com/record/api";
            }

            @Override
            public String getRequestString() {
                try {
                    JSONObject json = new JSONObject();
                    json.put("mh", (Object)"faceSdkStatistic");
                    Properties asCopy = (Properties)Ast.this.properties.clone();
                    Iterator<Map.Entry<Object, Object>> iter = asCopy.entrySet().iterator();
                    JSONArray dt = new JSONArray();
                    while (iter.hasNext()) {
                        Map.Entry<Object, Object> entry = iter.next();
                        String key = (String)entry.getKey();
                        String value = (String)entry.getValue();
                        if (key.equalsIgnoreCase(Ast.FACE_HIT_KEY_LASSTTIME) || key.equalsIgnoreCase(Ast.UPLOAD_LASSTTIME)) continue;
                        JSONObject data = new JSONObject();
                        data.put("type", (Object)"facesdk");
                        data.put("scene", (Object)Ast.this.scene);
                        data.put("appid", (Object)Ast.this.dev.getPackagename());
                        data.put("device", (Object)Ast.this.dev.getBrand());
                        data.put("imei", (Object)Ast.this.dev.getUniqueID());
                        data.put("os", (Object)"Android");
                        data.put("system", (Object)Ast.this.dev.getSysVersion());
                        data.put("version", (Object)Ast.this.dev.getSdkVersion());
                        if (key.contains("liveness")) {
                            data.put("isliving", (Object)"true");
                        } else {
                            data.put("isliving", (Object)"false");
                        }
                        data.put("finish", (Object)"1");
                        String[] keySplit = key.split("_");
                        if (keySplit.length > 4) {
                            data.put("year", (Object)keySplit[0]);
                            data.put("month", (Object)keySplit[1]);
                            data.put("day", (Object)keySplit[2]);
                            data.put("hour", (Object)keySplit[3]);
                        }
                        data.put("num", (Object)value);
                        dt.put((Object)data);
                    }
                    json.put("dt", (Object)dt);
                    return json.toString();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    return "";
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parseResponse(InputStream in) throws IOException, JSONException {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                try {
                    int len1;
                    while ((len1 = in.read(buffer)) > 0) {
                        out.write(buffer, 0, len1);
                    }
                    out.flush();
                    JSONObject json = new JSONObject(new String(out.toByteArray(), "UTF-8"));
                    int code = json.optInt("code");
                    if (code == 0) {
                        Ast.this.properties.clear();
                        Ast.this.dev.setFirstRun(false);
                        FileUtil.savePropertiesFile(Ast.this.asFile, Ast.this.properties);
                        Ast.this.properties.setProperty(Ast.UPLOAD_LASSTTIME, String.valueOf(System.currentTimeMillis()));
                    }
                }
                finally {
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }
}

